/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.api.Config;
import datadog.trace.common.sampling.AllSampler;
import datadog.trace.common.sampling.ForcePrioritySampler;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.RuleBasedSampler;
import datadog.trace.common.sampling.TraceSamplingRules;
import datadog.trace.core.CoreSpan;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Sampler<T extends CoreSpan<T>> {
    public boolean sample(T var1);

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static <T extends CoreSpan<T>> Sampler<T> forConfig(Config config) {
            Sampler sampler;
            if (config != null) {
                boolean jsonTraceSamplingRulesDefined;
                Map<String, String> serviceRules = config.getTraceSamplingServiceRules();
                Map<String, String> operationRules = config.getTraceSamplingOperationRules();
                String traceSamplingRulesJson = config.getTraceSamplingRules();
                TraceSamplingRules traceSamplingRules = null;
                if (traceSamplingRulesJson != null) {
                    try {
                        traceSamplingRules = TraceSamplingRules.deserialize(traceSamplingRulesJson);
                    }
                    catch (IOException e) {
                        log.error("Couldn't parse trace sampling rules from JSON", (Throwable)e);
                    }
                }
                boolean serviceRulesDefined = serviceRules != null && !serviceRules.isEmpty();
                boolean operationRulesDefined = operationRules != null && !operationRules.isEmpty();
                boolean bl = jsonTraceSamplingRulesDefined = traceSamplingRules != null && !traceSamplingRules.isEmpty();
                if ((serviceRulesDefined || operationRulesDefined) && jsonTraceSamplingRulesDefined) {
                    log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", new Object[]{"trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules"});
                }
                if (serviceRulesDefined || operationRulesDefined || jsonTraceSamplingRulesDefined || config.getTraceSampleRate() != null) {
                    try {
                        sampler = RuleBasedSampler.build(serviceRules, operationRules, traceSamplingRules, config.getTraceSampleRate(), config.getTraceRateLimit());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid sampler configuration. Using AllSampler", (Throwable)e);
                        sampler = new AllSampler();
                    }
                } else if (config.isPrioritySamplingEnabled()) {
                    if ("keep".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_KEEP.");
                        sampler = new ForcePrioritySampler(1, 0);
                    } else if ("drop".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_DROP.");
                        sampler = new ForcePrioritySampler(0, 0);
                    } else {
                        sampler = new RateByServiceSampler();
                    }
                } else {
                    sampler = new AllSampler();
                }
            } else {
                sampler = new AllSampler();
            }
            return sampler;
        }

        public static <T extends CoreSpan<T>> Sampler<T> forConfig(Properties config) {
            return Builder.forConfig(Config.get(config));
        }

        private Builder() {
        }
    }
}

