/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.civisibility;

import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDTraceCoreInfo;
import java.util.Collection;
import java.util.Collections;

public class CiVisibilityTraceInterceptor
implements TraceInterceptor {
    public static final CiVisibilityTraceInterceptor INSTANCE = new CiVisibilityTraceInterceptor();
    static final String TEST_TYPE = "test";
    static final UTF8BytesString CIAPP_TEST_ORIGIN = UTF8BytesString.create("ciapp-test");

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        if (trace.isEmpty()) {
            return trace;
        }
        DDSpan firstSpan = (DDSpan)trace.iterator().next();
        DDSpan localRootSpan = firstSpan.getLocalRootSpan();
        DDSpan spanToCheck = null == localRootSpan ? firstSpan : localRootSpan;
        CharSequence type = spanToCheck.getType();
        if (type == null || !TEST_TYPE.contentEquals(type)) {
            return Collections.emptyList();
        }
        for (MutableSpan mutableSpan : trace) {
            ((DDSpan)mutableSpan).context().setOrigin(CIAPP_TEST_ORIGIN);
            mutableSpan.setTag("library_version", DDTraceCoreInfo.VERSION);
        }
        return trace;
    }

    public int priority() {
        return 0;
    }
}

