/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.monitor;

import datadog.communication.monitor.DDAgentStatsDClient;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.function.Function;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingStatsDClient
implements StatsDClient {
    private static final Logger log = LoggerFactory.getLogger(LoggingStatsDClient.class);
    private static final String COUNT_FORMAT = "{}:{}|c{}";
    private static final String GAUGE_FORMAT = "{}:{}|g{}";
    private static final String HISTOGRAM_FORMAT = "{}:{}|h{}";
    private static final String SERVICE_CHECK_FORMAT = "_sc|{}|{}{}{}";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private final Function<String, String> nameMapping;
    private final Function<String[], String[]> tagMapping;

    public LoggingStatsDClient(Function<String, String> nameMapping, Function<String[], String[]> tagMapping) {
        this.nameMapping = nameMapping;
        this.tagMapping = tagMapping;
    }

    @Override
    public void incrementCounter(String metricName, String ... tags) {
        log.info(COUNT_FORMAT, new Object[]{this.nameMapping.apply(metricName), 1, LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void count(String metricName, long delta, String ... tags) {
        log.info(COUNT_FORMAT, new Object[]{this.nameMapping.apply(metricName), delta, LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void gauge(String metricName, long value, String ... tags) {
        log.info(GAUGE_FORMAT, new Object[]{this.nameMapping.apply(metricName), value, LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void gauge(String metricName, double value, String ... tags) {
        log.info(GAUGE_FORMAT, new Object[]{this.nameMapping.apply(metricName), DECIMAL_FORMAT.format(value), LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void histogram(String metricName, long value, String ... tags) {
        log.info(HISTOGRAM_FORMAT, new Object[]{this.nameMapping.apply(metricName), value, LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void histogram(String metricName, double value, String ... tags) {
        log.info(HISTOGRAM_FORMAT, new Object[]{this.nameMapping.apply(metricName), DECIMAL_FORMAT.format(value), LoggingStatsDClient.join(this.tagMapping.apply(tags))});
    }

    @Override
    public void serviceCheck(String serviceCheckName, String status, String message, String ... tags) {
        log.info(SERVICE_CHECK_FORMAT, new Object[]{this.nameMapping.apply(serviceCheckName), DDAgentStatsDClient.serviceCheckStatus(status).ordinal(), LoggingStatsDClient.join(this.tagMapping.apply(tags)), null != message ? "|m:" + message : ""});
    }

    @Override
    public void error(Exception error) {
    }

    @Override
    public int getErrorCount() {
        return 0;
    }

    @Override
    public void close() {
    }

    private static String join(String ... tags) {
        if (null == tags || tags.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder("|#").append(tags[0]);
        for (int i = 1; i < tags.length; ++i) {
            buf.append(',').append(tags[i]);
        }
        return buf.toString();
    }

    static {
        DECIMAL_FORMAT.setMaximumFractionDigits(6);
    }
}

