/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.LogHandler;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.OTSpan;
import datadog.opentracing.OTSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;

class TypeConverter {
    private final LogHandler logHandler;
    private final OTSpan noopSpanWrapper;
    private final OTSpanContext noopContextWrapper;
    private final OTScopeManager.OTScope noopScopeWrapper;

    public TypeConverter(LogHandler logHandler) {
        this.logHandler = logHandler;
        this.noopSpanWrapper = new OTSpan(AgentTracer.NoopAgentSpan.INSTANCE, this, logHandler);
        this.noopContextWrapper = new OTSpanContext(AgentTracer.NoopContext.INSTANCE);
        this.noopScopeWrapper = new OTScopeManager.OTScope(AgentTracer.NoopAgentScope.INSTANCE, false, this);
    }

    public AgentSpan toAgentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof OTSpan) {
            return ((OTSpan)span).getDelegate();
        }
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    public OTSpan toSpan(AgentSpan agentSpan) {
        if (agentSpan == null) {
            return null;
        }
        if (agentSpan instanceof AttachableWrapper) {
            AttachableWrapper attachableSpanWrapper = (AttachableWrapper)((Object)agentSpan);
            Object wrapper = attachableSpanWrapper.getWrapper();
            if (wrapper instanceof OTSpan) {
                return (OTSpan)wrapper;
            }
            OTSpan spanWrapper = new OTSpan(agentSpan, this, this.logHandler);
            attachableSpanWrapper.attachWrapper(spanWrapper);
            return spanWrapper;
        }
        if (agentSpan == AgentTracer.NoopAgentSpan.INSTANCE) {
            return this.noopSpanWrapper;
        }
        return new OTSpan(agentSpan, this, this.logHandler);
    }

    public AgentScope toAgentScope(Span span, Scope scope) {
        if (span == null && scope == null) {
            return null;
        }
        if (scope instanceof OTScopeManager.OTScope) {
            OTScopeManager.OTScope wrapper = (OTScopeManager.OTScope)scope;
            if (wrapper.isFinishSpanOnClose()) {
                return new FinishingScope(wrapper.unwrap());
            }
            return wrapper.unwrap();
        }
        return new CustomScope(span, scope);
    }

    public Scope toScope(AgentScope scope, boolean finishSpanOnClose) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof AttachableWrapper) {
            OTScopeManager.OTScope attachedScopeWrapper;
            AttachableWrapper attachableScopeWrapper = (AttachableWrapper)((Object)scope);
            Object wrapper = attachableScopeWrapper.getWrapper();
            if (wrapper instanceof OTScopeManager.OTScope && (attachedScopeWrapper = (OTScopeManager.OTScope)wrapper).isFinishSpanOnClose() == finishSpanOnClose) {
                return (Scope)wrapper;
            }
            OTScopeManager.OTScope otScope = new OTScopeManager.OTScope(scope, finishSpanOnClose, this);
            attachableScopeWrapper.attachWrapper(otScope);
            return otScope;
        }
        if (scope == AgentTracer.NoopAgentScope.INSTANCE) {
            return this.noopScopeWrapper;
        }
        return new OTScopeManager.OTScope(scope, finishSpanOnClose, this);
    }

    public SpanContext toSpanContext(AgentSpan.Context context) {
        if (context == null) {
            return null;
        }
        if (context == AgentTracer.NoopContext.INSTANCE) {
            return this.noopContextWrapper;
        }
        return new OTSpanContext(context);
    }

    public AgentSpan.Context toContext(SpanContext spanContext) {
        if (spanContext == null) {
            return null;
        }
        if (spanContext instanceof OTSpanContext) {
            return ((OTSpanContext)spanContext).getDelegate();
        }
        return AgentTracer.NoopContext.INSTANCE;
    }

    final class CustomScope
    implements AgentScope {
        private final Span span;
        private final Scope scope;

        private CustomScope(Span span, Scope scope) {
            this.span = span;
            this.scope = scope;
        }

        @Override
        public void close() {
            if (this.scope != null) {
                this.scope.close();
            }
        }

        @Override
        public AgentSpan span() {
            return TypeConverter.this.toAgentSpan(this.span);
        }

        @Override
        public byte source() {
            return ScopeSource.MANUAL.id();
        }

        @Override
        public AgentScope.Continuation capture() {
            return null;
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return null;
        }

        public boolean isAsyncPropagating() {
            return false;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CustomScope) {
                CustomScope customScope = (CustomScope)o;
                if (this.scope != null && customScope.scope != null) {
                    return this.scope.equals(customScope.scope);
                }
                return this.span.equals(customScope.span);
            }
            return false;
        }

        public int hashCode() {
            return this.scope != null ? this.scope.hashCode() : this.span.hashCode();
        }
    }

    static final class FinishingScope
    implements AgentScope {
        private final AgentScope delegate;

        private FinishingScope(AgentScope delegate) {
            this.delegate = delegate;
        }

        @Override
        public AgentSpan span() {
            return this.delegate.span();
        }

        @Override
        public byte source() {
            return this.delegate.source();
        }

        @Override
        public void close() {
            this.delegate.close();
            this.delegate.span().finish();
        }

        @Override
        public AgentScope.Continuation capture() {
            return this.delegate.capture();
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return this.delegate.captureConcurrent();
        }

        public boolean isAsyncPropagating() {
            return this.delegate.isAsyncPropagating();
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.delegate.setAsyncPropagation(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FinishingScope) {
                return this.delegate.equals(((FinishingScope)o).delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

