/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.DeterministicSampler;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.sampling.SamplingRule;
import datadog.trace.common.sampling.TraceSamplingRules;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.util.SimpleRateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedSampler<T extends CoreSpan<T>>
implements Sampler<T>,
PrioritySampler<T> {
    private static final Logger log = LoggerFactory.getLogger(RuleBasedSampler.class);
    private final List<SamplingRule<T>> samplingRules;
    private final PrioritySampler<T> fallbackSampler;
    private final SimpleRateLimiter rateLimiter;
    private final long rateLimit;
    public static final String SAMPLING_RULE_RATE = "_dd.rule_psr";
    public static final String SAMPLING_LIMIT_RATE = "_dd.limit_psr";

    public RuleBasedSampler(List<SamplingRule<T>> samplingRules, int rateLimit, PrioritySampler<T> fallbackSampler) {
        this.samplingRules = samplingRules;
        this.fallbackSampler = fallbackSampler;
        this.rateLimiter = new SimpleRateLimiter(rateLimit);
        this.rateLimit = rateLimit;
    }

    public static <T extends CoreSpan<T>> RuleBasedSampler<T> build(TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        return RuleBasedSampler.build(null, null, traceSamplingRules, defaultRate, rateLimit);
    }

    public static <T extends CoreSpan<T>> RuleBasedSampler<T> build(@Deprecated Map<String, String> serviceRules, @Deprecated Map<String, String> operationRules, TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        ArrayList<SamplingRule<T>> samplingRules = new ArrayList<SamplingRule<T>>();
        if (traceSamplingRules != null) {
            if (!(serviceRules.isEmpty() && operationRules.isEmpty() || traceSamplingRules.isEmpty())) {
                log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", new Object[]{"trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules"});
            }
            for (TraceSamplingRules.Rule rule : traceSamplingRules.getRules()) {
                SamplingRule.TraceSamplingRule samplingRule = new SamplingRule.TraceSamplingRule(rule.getService(), rule.getName(), new DeterministicSampler(rule.getSampleRate()));
                samplingRules.add(samplingRule);
            }
        } else {
            SamplingRule.PatternMatchSamplingRule samplingRule;
            if (serviceRules != null) {
                for (Map.Entry entry : serviceRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble((String)entry.getValue());
                        samplingRule = new SamplingRule.ServiceSamplingRule((String)entry.getKey(), new DeterministicSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for service: {}", (Object)entry, (Object)e);
                    }
                }
            }
            if (operationRules != null) {
                for (Map.Entry entry : operationRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble((String)entry.getValue());
                        samplingRule = new SamplingRule.OperationSamplingRule((String)entry.getKey(), new DeterministicSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for operation: {}", (Object)entry, (Object)e);
                    }
                }
            }
        }
        if (defaultRate != null) {
            SamplingRule.AlwaysMatchesSamplingRule samplingRule = new SamplingRule.AlwaysMatchesSamplingRule(new DeterministicSampler(defaultRate));
            samplingRules.add(samplingRule);
        }
        return new RuleBasedSampler<T>(samplingRules, rateLimit, new RateByServiceSampler());
    }

    @Override
    public boolean sample(T span) {
        return true;
    }

    @Override
    public void setSamplingPriority(T span) {
        SamplingRule<T> matchedRule = null;
        for (SamplingRule<T> samplingRule : this.samplingRules) {
            if (!samplingRule.matches(span)) continue;
            matchedRule = samplingRule;
            break;
        }
        if (matchedRule == null) {
            this.fallbackSampler.setSamplingPriority(span);
        } else if (matchedRule.sample(span)) {
            if (this.rateLimiter.tryAcquire()) {
                span.setSamplingPriority(2, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            } else {
                span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            }
            span.setMetric((CharSequence)SAMPLING_LIMIT_RATE, this.rateLimit);
        } else {
            span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
        }
    }
}

