/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import datadog.trace.api.Config;
import datadog.trace.core.DDTraceCoreInfo;
import datadog.trace.logging.LoggingSettingsDescription;
import datadog.trace.util.AgentTaskScheduler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusLogger
extends JsonAdapter<Config>
implements AgentTaskScheduler.Task<Config>,
JsonAdapter.Factory {
    public static void logStatus(Config config) {
        AgentTaskScheduler.INSTANCE.schedule(new StatusLogger(), config, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run(Config config) {
        Logger log = LoggerFactory.getLogger(StatusLogger.class);
        if (log.isInfoEnabled()) {
            log.info("DATADOG TRACER CONFIGURATION {}", (Object)new Moshi.Builder().add((JsonAdapter.Factory)this).build().adapter(Config.class).toJson((Object)config));
        }
        if (log.isDebugEnabled()) {
            log.debug("class path: {}", (Object)System.getProperty("java.class.path"));
        }
    }

    public Config fromJson(JsonReader reader) {
        throw new UnsupportedOperationException();
    }

    public void toJson(JsonWriter writer, Config config) throws IOException {
        if (null == config) {
            return;
        }
        writer.beginObject();
        writer.name("version");
        writer.value(DDTraceCoreInfo.VERSION);
        writer.name("os_name");
        writer.value(System.getProperty("os.name"));
        writer.name("os_version");
        writer.value(System.getProperty("os.version"));
        writer.name("architecture");
        writer.value(System.getProperty("os.arch"));
        writer.name("lang");
        writer.value("jvm");
        writer.name("lang_version");
        writer.value(System.getProperty("java.version"));
        writer.name("jvm_vendor");
        writer.value(System.getProperty("java.vendor"));
        writer.name("jvm_version");
        writer.value(System.getProperty("java.vm.version"));
        writer.name("java_class_version");
        writer.value(System.getProperty("java.class.version"));
        writer.name("http_nonProxyHosts");
        writer.value(String.valueOf(System.getProperty("http.nonProxyHosts")));
        writer.name("http_proxyHost");
        writer.value(String.valueOf(System.getProperty("http.proxyHost")));
        writer.name("enabled");
        writer.value(config.isTraceEnabled());
        writer.name("service");
        writer.value(config.getServiceName());
        writer.name("agent_url");
        writer.value(config.getAgentUrl());
        writer.name("agent_unix_domain_socket");
        writer.value(config.getAgentUnixDomainSocket());
        writer.name("agent_named_pipe");
        writer.value(config.getAgentNamedPipe());
        writer.name("agent_error");
        writer.value(!StatusLogger.agentServiceCheck(config));
        writer.name("debug");
        writer.value(config.isDebugEnabled());
        writer.name("analytics_enabled");
        writer.value(config.isTraceAnalyticsEnabled());
        writer.name("sample_rate");
        writer.value((Number)config.getTraceSampleRate());
        writer.name("sampling_rules");
        writer.beginArray();
        StatusLogger.writeMap(writer, config.getTraceSamplingServiceRules());
        StatusLogger.writeMap(writer, config.getTraceSamplingOperationRules());
        writer.endArray();
        writer.name("priority_sampling_enabled");
        writer.value(config.isPrioritySamplingEnabled());
        writer.name("logs_correlation_enabled");
        writer.value(config.isLogsInjectionEnabled());
        writer.name("profiling_enabled");
        writer.value(config.isProfilingEnabled());
        writer.name("remote_config_enabled");
        writer.value(config.isRemoteConfigEnabled());
        writer.name("debugger_enabled");
        writer.value(config.isDebuggerEnabled());
        writer.name("appsec_enabled");
        writer.value(config.getAppSecEnabledConfig().toString());
        writer.name("appsec_rules_file_path");
        writer.value(config.getAppSecRulesFile());
        writer.name("telemetry_enabled");
        writer.value(config.isTelemetryEnabled());
        writer.name("dd_version");
        writer.value(config.getVersion());
        writer.name("health_checks_enabled");
        writer.value(config.isHealthMetricsEnabled());
        writer.name("configuration_file");
        writer.value(config.getConfigFileStatus());
        writer.name("runtime_id");
        writer.value(config.getRuntimeId());
        writer.name("logging_settings");
        StatusLogger.writeObjectMap(writer, LoggingSettingsDescription.getDescription());
        writer.name("cws_enabled");
        writer.value(config.isCwsEnabled());
        writer.name("cws_tls_refresh");
        writer.value((long)config.getCwsTlsRefresh());
        writer.endObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean agentServiceCheck(Config config) {
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(config.getAgentHost(), config.getAgentPort()), 500);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void writeMap(JsonWriter writer, Map<String, String> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            writer.name(entry.getKey());
            writer.value(entry.getValue());
        }
        writer.endObject();
    }

    private static void writeObjectMap(JsonWriter writer, Map<String, Object> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.name(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Number) {
                writer.value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.value((Boolean)value);
                continue;
            }
            writer.value(String.valueOf(value));
        }
        writer.endObject();
    }

    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        return this;
    }
}

