/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.resolver;

import datadog.opentracing.DDTracer;
import datadog.trace.common.util.Config;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracerResolver
extends TracerResolver {
    private static final Logger log = LoggerFactory.getLogger(DDTracerResolver.class);
    static final String CONFIG_KEY = "dd.trace.resolver.enabled";

    public static Tracer registerTracer() {
        Tracer tracer = TracerResolver.resolveTracer();
        if (tracer == null) {
            log.warn("Cannot resolved the tracer, use NoopTracer");
            return NoopTracerFactory.create();
        }
        log.info("Register the tracer via GlobalTracer");
        GlobalTracer.register((Tracer)tracer);
        return tracer;
    }

    protected Tracer resolve() {
        boolean enabled;
        boolean bl = enabled = !"false".equalsIgnoreCase(Config.getPropOrEnv(CONFIG_KEY));
        if (enabled) {
            log.info("Creating DDTracer with DDTracerResolver");
            return new DDTracer();
        }
        log.info("DDTracerResolver disabled");
        return null;
    }
}

