/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.DDSpan;
import datadog.opentracing.scopemanager.ContinuableScope;
import datadog.opentracing.scopemanager.ScopeContext;
import datadog.opentracing.scopemanager.SimpleScope;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ContextualScopeManager
implements ScopeManager {
    static final ThreadLocal<Scope> tlsScope = new ThreadLocal();
    final Deque<ScopeContext> scopeContexts = new ConcurrentLinkedDeque<ScopeContext>();

    public Scope activate(Span span, boolean finishOnClose) {
        for (ScopeContext context : this.scopeContexts) {
            if (!context.inContext()) continue;
            return context.activate(span, finishOnClose);
        }
        if (span instanceof DDSpan) {
            return new ContinuableScope(this, (DDSpan)span, finishOnClose);
        }
        return new SimpleScope(this, span, finishOnClose);
    }

    public Scope active() {
        for (ScopeContext csm : this.scopeContexts) {
            if (!csm.inContext()) continue;
            return csm.active();
        }
        return tlsScope.get();
    }

    public void addScopeContext(ScopeContext context) {
        this.scopeContexts.addFirst(context);
    }
}

