/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.google.common.annotations.VisibleForTesting;
import datadog.opentracing.DDSpan;
import datadog.trace.api.CorrelationIdentifier;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;

public class OTTraceCorrelation
implements CorrelationIdentifier.Provider {
    public static final OTTraceCorrelation INSTANCE = new OTTraceCorrelation();
    private final Tracer tracer;

    private OTTraceCorrelation() {
        this(GlobalTracer.get());
    }

    @VisibleForTesting
    OTTraceCorrelation(Tracer tracer) {
        this.tracer = tracer;
    }

    public String getTraceId() {
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getTraceId();
        }
        return "0";
    }

    public String getSpanId() {
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId();
        }
        return "0";
    }
}

