/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);

    public static String getPropOrEnv(String name) {
        return System.getProperty(name, System.getenv(Config.propToEnvName(name)));
    }

    public static String propToEnvName(String name) {
        return name.toUpperCase().replace(".", "_");
    }

    public static Map<String, String> parseMap(String str, String settingName) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (!str.matches("(([^,:]+:[^,:]*,)*([^,:]+:[^,:]*),?)?")) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2'.", (Object)settingName, (Object)str);
            return Collections.emptyMap();
        }
        String[] tokens = str.split(",", -1);
        HashMap<String, String> map = new HashMap<String, String>(tokens.length + 1, 1.0f);
        for (String token : tokens) {
            String[] keyValue = token.split(":", -1);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (value.length() <= 0) {
                log.warn("Ignoring empty value for key '{}' in config for {}", (Object)key, (Object)settingName);
                continue;
            }
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }
}

