/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common;

import datadog.trace.common.util.Config;
import datadog.trace.common.writer.Writer;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTraceConfig
extends Properties {
    private static final Logger log = LoggerFactory.getLogger(DDTraceConfig.class);
    private static final String PREFIX = "dd.";
    public static final String SERVICE_NAME = "service.name";
    public static final String SERVICE_MAPPING = "service.mapping";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String AGENT_PORT = "agent.port";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    public static final String SPAN_TAGS = "trace.span.tags";
    public static final String HEADER_TAGS = "trace.header.tags";
    private final String serviceName = Config.getPropOrEnv("dd.service.name");
    private final String serviceMapping = Config.getPropOrEnv("dd.service.mapping");
    private final String writerType = Config.getPropOrEnv("dd.writer.type");
    private final String agentHost = Config.getPropOrEnv("dd.agent.host");
    private final String agentPort = Config.getPropOrEnv("dd.agent.port");
    private final String prioritySampling = Config.getPropOrEnv("dd.priority.sampling");
    private final String spanTags = Config.getPropOrEnv("dd.trace.span.tags");
    private final String headerTags = Config.getPropOrEnv("dd.trace.header.tags");

    public DDTraceConfig() {
        Properties defaults = new Properties();
        defaults.setProperty(SERVICE_NAME, "unnamed-java-app");
        defaults.setProperty(WRITER_TYPE, Writer.DD_AGENT_WRITER_TYPE);
        defaults.setProperty(AGENT_HOST, "localhost");
        defaults.setProperty(AGENT_PORT, String.valueOf(8126));
        this.defaults = defaults;
        this.setIfNotNull(SERVICE_NAME, this.serviceName);
        this.setIfNotNull(SERVICE_MAPPING, this.serviceMapping);
        this.setIfNotNull(WRITER_TYPE, this.writerType);
        this.setIfNotNull(AGENT_HOST, this.agentHost);
        this.setIfNotNull(AGENT_PORT, this.agentPort);
        this.setIfNotNull(PRIORITY_SAMPLING, this.prioritySampling);
        this.setIfNotNull(SPAN_TAGS, this.spanTags);
        this.setIfNotNull(HEADER_TAGS, this.headerTags);
    }

    public DDTraceConfig(String serviceName) {
        this();
        this.put(SERVICE_NAME, serviceName);
    }

    private void setIfNotNull(String key, String value) {
        if (value != null) {
            this.setProperty(key, value);
        }
    }
}

