/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.common.writer.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ListWriter
extends CopyOnWriteArrayList<List<DDSpan>>
implements Writer {
    private final List<CountDownLatch> latches = new ArrayList<CountDownLatch>();

    public List<DDSpan> firstTrace() {
        return (List)this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<DDSpan> trace) {
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            this.add(trace);
            for (CountDownLatch latch : this.latches) {
                if ((long)this.size() < latch.getCount()) continue;
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTraces(int number) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(number);
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            if (this.size() >= number) {
                return;
            }
            this.latches.add(latch);
        }
        if (!latch.await(20L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Timeout waiting for " + number + " trace(s). ListWriter.size() == " + this.size());
        }
    }

    @Override
    public void start() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.clear();
        List<CountDownLatch> list = this.latches;
        synchronized (list) {
            for (CountDownLatch latch : this.latches) {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
            this.latches.clear();
        }
    }

    @Override
    public String toString() {
        return "ListWriter { size=" + this.size() + " }";
    }
}

