/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.propagation.TagContext;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExtractedContext
extends TagContext {
    private final String traceId;
    private final String spanId;
    private final int samplingPriority;
    private final Map<String, String> baggage;
    private final AtomicBoolean samplingPriorityLocked = new AtomicBoolean(false);

    public ExtractedContext(String traceId, String spanId, int samplingPriority, Map<String, String> baggage, Map<String, String> tags) {
        super(tags);
        this.traceId = traceId;
        this.spanId = spanId;
        this.samplingPriority = samplingPriority;
        this.baggage = baggage;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public void lockSamplingPriority() {
        this.samplingPriorityLocked.set(true);
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public int getSamplingPriority() {
        return this.samplingPriority;
    }

    public Map<String, String> getBaggage() {
        return this.baggage;
    }

    public boolean getSamplingPriorityLocked() {
        return this.samplingPriorityLocked.get();
    }
}

