/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.DDSpan;
import datadog.opentracing.DDSpanContext;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.decorators.AbstractDecorator;
import datadog.opentracing.decorators.DDDecoratorsFactory;
import datadog.opentracing.propagation.DatadogHttpCodec;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.TagContext;
import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.opentracing.scopemanager.ScopeContext;
import datadog.trace.api.Config;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.common.sampling.RateByServiceSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.DDApi;
import datadog.trace.common.writer.Writer;
import datadog.trace.context.ScopeListener;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracer
implements Tracer,
Closeable,
datadog.trace.api.Tracer {
    private static final Logger log = LoggerFactory.getLogger(DDTracer.class);
    final String serviceName;
    final Writer writer;
    final Sampler sampler;
    final ContextualScopeManager scopeManager = new ContextualScopeManager();
    final Map<String, String> runtimeTags;
    private final Map<String, String> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final Thread shutdownCallback;
    private final Map<String, List<AbstractDecorator>> spanContextDecorators = new ConcurrentHashMap<String, List<AbstractDecorator>>();
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final DatadogHttpCodec.Injector injector;
    private final DatadogHttpCodec.Extractor extractor;
    private final AtomicInteger traceCount;

    public DDTracer() {
        this(Config.get());
    }

    public DDTracer(String serviceName) {
        this(serviceName, Config.get());
    }

    public DDTracer(Properties config) {
        this(Config.get((Properties)config));
    }

    public DDTracer(Config config) {
        this(config.getServiceName(), config);
    }

    public DDTracer(String serviceName, Writer writer, Sampler sampler) {
        this(serviceName, writer, sampler, Config.get().getRuntimeTags());
    }

    private DDTracer(String serviceName, Config config) {
        this(serviceName, Writer.Builder.forConfig(config), Sampler.Builder.forConfig(config), config.getRuntimeTags(), config.getMergedSpanTags(), config.getServiceMapping(), config.getHeaderTags(), config.getPartialFlushMinSpans());
        log.debug("Using config: {}", (Object)config);
    }

    DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> runtimeTags) {
        this(serviceName, writer, sampler, runtimeTags, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0);
    }

    public DDTracer(Writer writer) {
        this(Config.get(), writer);
    }

    public DDTracer(Config config, Writer writer) {
        this(config.getServiceName(), writer, Sampler.Builder.forConfig(config), config.getRuntimeTags(), config.getMergedSpanTags(), config.getServiceMapping(), config.getHeaderTags(), config.getPartialFlushMinSpans());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler, String runtimeId, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders) {
        this(serviceName, writer, sampler, DDTracer.customRuntimeTags(runtimeId), defaultSpanTags, serviceNameMappings, taggedHeaders, Config.get().getPartialFlushMinSpans());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> runtimeTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders) {
        this(serviceName, writer, sampler, runtimeTags, defaultSpanTags, serviceNameMappings, taggedHeaders, Config.get().getPartialFlushMinSpans());
    }

    public DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> runtimeTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans) {
        assert (runtimeTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.serviceName = serviceName;
        this.writer = writer;
        this.writer.start();
        this.sampler = sampler;
        this.defaultSpanTags = defaultSpanTags;
        this.runtimeTags = runtimeTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.injector = new DatadogHttpCodec.Injector();
        this.extractor = new DatadogHttpCodec.Extractor(taggedHeaders);
        if (this.writer instanceof DDAgentWriter) {
            DDApi api = ((DDAgentWriter)this.writer).getApi();
            this.traceCount = api.getTraceCounter();
            if (sampler instanceof DDApi.ResponseListener) {
                api.addResponseListener((DDApi.ResponseListener)((Object)this.sampler));
            }
        } else {
            this.traceCount = new AtomicInteger(0);
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        List<AbstractDecorator> decorators = DDDecoratorsFactory.createBuiltinDecorators();
        for (AbstractDecorator decorator : decorators) {
            log.debug("Loading decorator: {}", (Object)decorator.getClass().getSimpleName());
            this.addDecorator(decorator);
        }
        log.info("New instance: {}", (Object)this);
    }

    public void finalize() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
            this.shutdownCallback.run();
        }
        catch (Exception e) {
            log.error("Error while finalizing DDTracer.", (Throwable)e);
        }
    }

    public List<AbstractDecorator> getSpanContextDecorators(String tag) {
        return this.spanContextDecorators.get(tag);
    }

    public void addDecorator(AbstractDecorator decorator) {
        List<AbstractDecorator> list = this.spanContextDecorators.get(decorator.getMatchingTag());
        if (list == null) {
            list = new ArrayList<AbstractDecorator>();
        }
        list.add(decorator);
        this.spanContextDecorators.put(decorator.getMatchingTag(), list);
    }

    public void addScopeContext(ScopeContext context) {
        this.scopeManager.addScopeContext(context);
    }

    public void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    public ContextualScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        Scope active = this.scopeManager.active();
        return active == null ? null : active.span();
    }

    public DDSpanBuilder buildSpan(String operationName) {
        return new DDSpanBuilder(operationName, this.scopeManager);
    }

    public <T> void inject(SpanContext spanContext, Format<T> format, T carrier) {
        if (carrier instanceof TextMap) {
            this.injector.inject((DDSpanContext)spanContext, (TextMap)carrier);
        } else {
            log.debug("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        }
    }

    public <T> SpanContext extract(Format<T> format, T carrier) {
        if (carrier instanceof TextMap) {
            return this.extractor.extract((TextMap)carrier);
        }
        log.debug("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        return null;
    }

    void write(Collection<DDSpan> trace) {
        ArrayList<DDSpan> writtenTrace;
        if (trace.isEmpty()) {
            return;
        }
        if (this.interceptors.isEmpty()) {
            writtenTrace = new ArrayList<DDSpan>(trace);
        } else {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
            }
            writtenTrace = new ArrayList(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        this.incrementTraceCount();
        if (!writtenTrace.isEmpty() && this.sampler.sample(writtenTrace.get(0))) {
            this.writer.write(writtenTrace);
        }
    }

    void incrementTraceCount() {
        this.traceCount.incrementAndGet();
    }

    public String getTraceId() {
        Span activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getTraceId();
        }
        return "0";
    }

    public String getSpanId() {
        Span activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId();
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeManager.addScopeListener(listener);
    }

    @Override
    public void close() {
        PendingTrace.close();
        this.writer.close();
    }

    public String toString() {
        return "DDTracer-" + Integer.toHexString(this.hashCode()) + "{ serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", defaultSpanTags=" + this.defaultSpanTags + '}';
    }

    @Deprecated
    private static Map<String, String> customRuntimeTags(String runtimeId) {
        HashMap<String, String> runtimeTags = new HashMap<String, String>();
        runtimeTags.putAll(Config.get().getRuntimeTags());
        runtimeTags.put("runtime-id", runtimeId);
        return Collections.unmodifiableMap(runtimeTags);
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<DDTracer> reference;

        private ShutdownHook(DDTracer tracer) {
            this.reference = new WeakReference<DDTracer>(tracer);
        }

        @Override
        public void run() {
            DDTracer tracer = (DDTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class DDSpanBuilder
    implements Tracer.SpanBuilder {
        private final ScopeManager scopeManager;
        private final String operationName;
        private final Map<String, Object> tags;
        private long timestampMicro;
        private SpanContext parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private String spanType;
        private boolean ignoreScope;

        public DDSpanBuilder(String operationName, ScopeManager scopeManager) {
            this.tags = new HashMap<String, Object>(DDTracer.this.defaultSpanTags);
            this.ignoreScope = false;
            this.operationName = operationName;
            this.scopeManager = scopeManager;
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan startSpan() {
            DDSpan span = new DDSpan(this.timestampMicro, this.buildSpanContext());
            if (DDTracer.this.sampler instanceof RateByServiceSampler) {
                ((RateByServiceSampler)DDTracer.this.sampler).initializeSamplingPriority(span);
            }
            return span;
        }

        public Scope startActive(boolean finishSpanOnClose) {
            DDSpan span = this.startSpan();
            Scope scope = this.scopeManager.activate((Span)span, finishSpanOnClose);
            log.debug("Starting a new active span: {}", (Object)span);
            return scope;
        }

        @Deprecated
        public DDSpan startManual() {
            return this.start();
        }

        public DDSpan start() {
            DDSpan span = this.startSpan();
            log.debug("Starting a new span: {}", (Object)span);
            return span;
        }

        public DDSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        public DDSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        public DDSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        public DDSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        public DDSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public DDSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public DDSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        public DDSpanBuilder withSpanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            if (this.parent == null) {
                return Collections.emptyList();
            }
            return this.parent.baggageItems();
        }

        public DDSpanBuilder asChildOf(Span span) {
            return this.asChildOf(span == null ? null : span.context());
        }

        public DDSpanBuilder asChildOf(SpanContext spanContext) {
            this.parent = spanContext;
            return this;
        }

        public DDSpanBuilder addReference(String referenceType, SpanContext spanContext) {
            if (spanContext == null) {
                return this;
            }
            if (!(spanContext instanceof ExtractedContext) && !(spanContext instanceof DDSpanContext)) {
                log.debug("Expected to have a DDSpanContext or ExtractedContext but got " + spanContext.getClass().getName());
                return this;
            }
            if ("child_of".equals(referenceType) || "follows_from".equals(referenceType)) {
                return this.asChildOf(spanContext);
            }
            log.debug("Only support reference type of CHILD_OF and FOLLOWS_FROM");
            return this;
        }

        private DDSpanBuilder withTag(String tag, Object value) {
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                this.tags.remove(tag);
            } else {
                this.tags.put(tag, value);
            }
            return this;
        }

        private String generateNewId() {
            return String.valueOf(ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE));
        }

        private DDSpanContext buildSpanContext() {
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            String parentSpanId;
            String traceId;
            Scope scope;
            String spanId = this.generateNewId();
            SpanContext parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (scope = this.scopeManager.active()) != null) {
                parentContext = scope.span().context();
            }
            if (parentContext instanceof DDSpanContext) {
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = Integer.MIN_VALUE;
                if (this.serviceName == null) {
                    this.serviceName = ddsc.getServiceName();
                }
                if (this.spanType == null) {
                    this.spanType = ddsc.getSpanType();
                }
            } else {
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    baggage = extractedContext.getBaggage();
                } else {
                    traceId = this.generateNewId();
                    parentSpanId = "0";
                    samplingPriority = Integer.MIN_VALUE;
                    baggage = null;
                }
                if (parentContext instanceof TagContext) {
                    this.tags.putAll(((TagContext)parentContext).getTags());
                }
                for (Map.Entry entry : DDTracer.this.runtimeTags.entrySet()) {
                    this.tags.put((String)entry.getKey(), entry.getValue());
                }
                parentTrace = new PendingTrace(DDTracer.this, traceId, DDTracer.this.serviceNameMappings);
            }
            if (this.serviceName == null) {
                this.serviceName = DDTracer.this.serviceName;
            }
            String operationName = this.operationName != null ? this.operationName : this.resourceName;
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, this.serviceName, operationName, this.resourceName, samplingPriority, baggage, this.errorFlag, this.spanType, this.tags, parentTrace, DDTracer.this);
            for (Map.Entry<String, Object> tag : this.tags.entrySet()) {
                if (tag.getValue() == null) {
                    context.setTag(tag.getKey(), null);
                    continue;
                }
                boolean addTag = true;
                List<AbstractDecorator> decorators = DDTracer.this.getSpanContextDecorators(tag.getKey());
                if (decorators != null) {
                    for (AbstractDecorator decorator : decorators) {
                        try {
                            addTag &= decorator.shouldSetTag(context, tag.getKey(), tag.getValue());
                        }
                        catch (Throwable ex) {
                            log.debug("Could not decorate the span decorator={}: {}", (Object)decorator.getClass().getSimpleName(), (Object)ex.getMessage());
                        }
                    }
                }
                if (addTag) continue;
                context.setTag(tag.getKey(), null);
            }
            return context;
        }
    }
}

