/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(DatadogHttpCodec.class);
    static final BigInteger BIG_INTEGER_UINT64_MAX = new BigInteger("2").pow(64).subtract(BigInteger.ONE);
    private static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String TRACE_ID_KEY = "x-datadog-trace-id";
    private static final String SPAN_ID_KEY = "x-datadog-parent-id";
    private static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";

    public static class Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
            }
        }

        public SpanContext extract(TextMap carrier) {
            Map<String, String> baggage = Collections.emptyMap();
            Map<String, String> tags = Collections.emptyMap();
            String traceId = "0";
            String spanId = "0";
            int samplingPriority = Integer.MIN_VALUE;
            for (Map.Entry entry : carrier) {
                String key = ((String)entry.getKey()).toLowerCase();
                String val = (String)entry.getValue();
                if (val == null) continue;
                if (DatadogHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                    traceId = this.validateUInt64BitsID(val);
                } else if (DatadogHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                    spanId = this.validateUInt64BitsID(val);
                } else if (key.startsWith(DatadogHttpCodec.OT_BAGGAGE_PREFIX)) {
                    if (baggage.isEmpty()) {
                        baggage = new HashMap<String, String>();
                    }
                    baggage.put(key.replace(DatadogHttpCodec.OT_BAGGAGE_PREFIX, ""), this.decode(val));
                } else if (DatadogHttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                    samplingPriority = Integer.parseInt(val);
                }
                if (!this.taggedHeaders.containsKey(key)) continue;
                if (tags.isEmpty()) {
                    tags = new HashMap<String, String>();
                }
                tags.put(this.taggedHeaders.get(key), this.decode(val));
            }
            TagContext context = null;
            if (!"0".equals(traceId)) {
                ExtractedContext ctx = new ExtractedContext(traceId, spanId, samplingPriority, baggage, tags);
                ctx.lockSamplingPriority();
                log.debug("{} - Parent context extracted", (Object)ctx.getTraceId());
                context = ctx;
            } else if (!tags.isEmpty()) {
                context = new TagContext(tags);
            }
            return context;
        }

        private String decode(String value) {
            String decoded = value;
            try {
                decoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.info("Failed to decode value - {}", (Object)value);
            }
            return decoded;
        }

        private String validateUInt64BitsID(String val) throws IllegalArgumentException {
            try {
                BigInteger validate = new BigInteger(val);
                if (validate.compareTo(BigInteger.ZERO) == -1 || validate.compareTo(BIG_INTEGER_UINT64_MAX) == 1) {
                    throw new IllegalArgumentException("ID out of range, must be between 0 and 2^64-1, got: " + val);
                }
                return val;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Expecting a number for trace ID or span ID, but got: " + val, nfe);
            }
        }
    }

    public static class Injector {
        public void inject(DDSpanContext context, TextMap carrier) {
            carrier.put(DatadogHttpCodec.TRACE_ID_KEY, String.valueOf(context.getTraceId()));
            carrier.put(DatadogHttpCodec.SPAN_ID_KEY, String.valueOf(context.getSpanId()));
            if (context.lockSamplingPriority()) {
                carrier.put(DatadogHttpCodec.SAMPLING_PRIORITY_KEY, String.valueOf(context.getSamplingPriority()));
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                carrier.put(DatadogHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), this.encode(entry.getValue()));
            }
            log.debug("{} - Parent context injected", (Object)context.getTraceId());
        }

        private String encode(String value) {
            String encoded = value;
            try {
                encoded = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.info("Failed to encode value - {}", (Object)value);
            }
            return encoded;
        }
    }
}

