/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTraceOTInfo;
import datadog.trace.common.writer.unixdomainsockets.UnixDomainSocketFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDApi {
    private static final Logger log = LoggerFactory.getLogger(DDApi.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final int HTTP_TIMEOUT = 1;
    private static final String TRACES_ENDPOINT_V3 = "v0.3/traces";
    private static final String TRACES_ENDPOINT_V4 = "v0.4/traces";
    private static final long MILLISECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toMillis(5L);
    private final List<ResponseListener> responseListeners = new ArrayList<ResponseListener>();
    private volatile long nextAllowedLogTime = 0L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private final OkHttpClient httpClient;
    private final HttpUrl tracesUrl;

    public DDApi(String host, int port, String unixDomainSocketPath) {
        this(host, port, DDApi.traceEndpointAvailable(DDApi.getUrl(host, port, TRACES_ENDPOINT_V4), unixDomainSocketPath), unixDomainSocketPath);
    }

    DDApi(String host, int port, boolean v4EndpointsAvailable, String unixDomainSocketPath) {
        this.httpClient = DDApi.buildHttpClient(unixDomainSocketPath);
        if (v4EndpointsAvailable) {
            this.tracesUrl = DDApi.getUrl(host, port, TRACES_ENDPOINT_V4);
        } else {
            log.debug("API v0.4 endpoints not available. Downgrading to v0.3");
            this.tracesUrl = DDApi.getUrl(host, port, TRACES_ENDPOINT_V3);
        }
    }

    public void addResponseListener(ResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    public boolean sendTraces(List<List<DDSpan>> traces) {
        ArrayList<byte[]> serializedTraces = new ArrayList<byte[]>(traces.size());
        int sizeInBytes = 0;
        for (List<DDSpan> trace : traces) {
            try {
                byte[] serializedTrace = this.serializeTrace(trace);
                sizeInBytes += serializedTrace.length;
                serializedTraces.add(serializedTrace);
            }
            catch (JsonProcessingException e) {
                log.warn("Error serializing trace", (Throwable)e);
            }
        }
        return this.sendSerializedTraces(serializedTraces.size(), sizeInBytes, serializedTraces);
    }

    byte[] serializeTrace(List<DDSpan> trace) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(trace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sendSerializedTraces(int representativeCount, final Integer sizeInBytes, final List<byte[]> traces) {
        try {
            RequestBody body = new RequestBody(){

                public MediaType contentType() {
                    return MSGPACK;
                }

                public long contentLength() {
                    int traceCount = traces.size();
                    if (traceCount < 16) {
                        return sizeInBytes + 1;
                    }
                    if (traceCount < 65536) {
                        return sizeInBytes + 2;
                    }
                    return sizeInBytes + 4;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    OutputStream out = sink.outputStream();
                    MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
                    packer.packArrayHeader(traces.size());
                    for (byte[] trace : traces) {
                        packer.writePayload(trace);
                    }
                    packer.close();
                    out.close();
                }
            };
            Request request = DDApi.prepareRequest(this.tracesUrl).addHeader(X_DATADOG_TRACE_COUNT, String.valueOf(representativeCount)).put(body).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.code() != 200) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error while sending {} of {} traces to the DD agent. Status: {}, Response: {}, Body: {}", new Object[]{traces.size(), representativeCount, response.code(), response.message(), response.body().string()});
                    } else if (this.nextAllowedLogTime < System.currentTimeMillis()) {
                        this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
                        log.warn("Error while sending {} of {} traces to the DD agent. Status: {} (going silent for {} seconds)", new Object[]{traces.size(), representativeCount, response.code(), response.message(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                log.debug("Successfully sent {} of {} traces to the DD agent.", (Object)traces.size(), (Object)representativeCount);
                String responseString = response.body().string().trim();
                try {
                    if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                        JsonNode parsedResponse = OBJECT_MAPPER.readTree(responseString);
                        String endpoint = this.tracesUrl.toString();
                        for (ResponseListener listener : this.responseListeners) {
                            listener.onResponse(endpoint, parsedResponse);
                        }
                    }
                }
                catch (JsonParseException e) {
                    log.debug("Failed to parse DD agent response: " + responseString, (Throwable)e);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while sending " + traces.size() + " of " + representativeCount + " traces to the DD agent.", (Throwable)e);
                return false;
            }
            if (this.nextAllowedLogTime >= System.currentTimeMillis()) return false;
            this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
            log.warn("Error while sending {} of {} traces to the DD agent. {}: {} (going silent for {} minutes)", new Object[]{traces.size(), representativeCount, e.getClass().getName(), e.getMessage(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
            return false;
        }
    }

    private static boolean traceEndpointAvailable(HttpUrl url, String unixDomainSocketPath) {
        return DDApi.endpointAvailable(url, unixDomainSocketPath, Collections.emptyList(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean endpointAvailable(HttpUrl url, String unixDomainSocketPath, Object data, boolean retry) {
        try {
            OkHttpClient client = DDApi.buildHttpClient(unixDomainSocketPath);
            RequestBody body = RequestBody.create((MediaType)MSGPACK, (byte[])OBJECT_MAPPER.writeValueAsBytes(data));
            Request request = DDApi.prepareRequest(url).put(body).build();
            try (Response response = client.newCall(request).execute();){
                boolean bl = response.code() == 200;
                return bl;
            }
        }
        catch (IOException e) {
            if (!retry) return false;
            return DDApi.endpointAvailable(url, unixDomainSocketPath, data, false);
        }
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder = builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        return builder.connectTimeout(1L, TimeUnit.SECONDS).writeTimeout(1L, TimeUnit.SECONDS).readTimeout(1L, TimeUnit.SECONDS).build();
    }

    private static HttpUrl getUrl(String host, int port, String endPoint) {
        return new HttpUrl.Builder().scheme("http").host(host).port(port).addEncodedPathSegments(endPoint).build();
    }

    private static Request.Builder prepareRequest(HttpUrl url) {
        return new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, DDTraceOTInfo.JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, DDTraceOTInfo.JAVA_VM_NAME).addHeader(DATADOG_META_TRACER_VERSION, DDTraceOTInfo.VERSION);
    }

    public String toString() {
        return "DDApi { tracesUrl=" + this.tracesUrl + " }";
    }

    public static interface ResponseListener {
        public void onResponse(String var1, JsonNode var2);
    }
}

