/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;

public class Status5XXDecorator
extends AbstractDecorator {
    public Status5XXDecorator() {
        this.setMatchingTag(Tags.HTTP_STATUS.getKey());
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        int responseCode = Integer.parseInt(value.toString());
        if (500 <= responseCode && responseCode < 600) {
            context.setTag(Tags.ERROR.getKey(), true);
        }
        return true;
    }
}

