/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.opentracing.DDSpan;
import datadog.trace.common.sampling.AbstractSampler;
import datadog.trace.common.sampling.AllSampler;
import datadog.trace.common.sampling.RateSampler;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Sampler {
    public static final String ALL_SAMPLER_TYPE = AllSampler.class.getSimpleName();
    public static final String RATE_SAMPLER_TYPE = RateSampler.class.getSimpleName();

    public boolean sample(DDSpan var1);

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Sampler forConfig(Properties config) {
            AbstractSampler sampler;
            if (config != null) {
                String configuredType = config.getProperty("sampler.type");
                if (RATE_SAMPLER_TYPE.equals(configuredType)) {
                    sampler = new RateSampler(config.getProperty("sampler.rate"));
                } else if (ALL_SAMPLER_TYPE.equals(configuredType)) {
                    sampler = new AllSampler();
                } else {
                    log.warn("Sampler type not configured correctly: Type {} not recognized. Defaulting to AllSampler.", (Object)configuredType);
                    sampler = new AllSampler();
                }
            } else {
                log.warn("Sampler type not configured correctly: No config provided! Defaulting to AllSampler.");
                sampler = new AllSampler();
            }
            return sampler;
        }

        private Builder() {
        }
    }
}

