/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.RateLimiter;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTraceOTInfo;
import datadog.trace.common.Service;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDApi {
    private static final Logger log = LoggerFactory.getLogger(DDApi.class);
    private static final String TRACES_ENDPOINT = "/v0.3/traces";
    private static final String SERVICES_ENDPOINT = "/v0.3/services";
    private static final long SECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toSeconds(5L);
    private final String tracesEndpoint;
    private final String servicesEndpoint;
    private final RateLimiter loggingRateLimiter = RateLimiter.create((double)(1.0 / (double)SECONDS_BETWEEN_ERROR_LOG));
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public DDApi(String host, int port) {
        this.tracesEndpoint = "http://" + host + ":" + port + TRACES_ENDPOINT;
        this.servicesEndpoint = "http://" + host + ":" + port + SERVICES_ENDPOINT;
    }

    public boolean sendTraces(List<List<DDSpan>> traces) {
        return this.putContent("traces", this.tracesEndpoint, traces, traces.size());
    }

    public boolean sendServices(Map<String, Service> services) {
        if (services == null) {
            return true;
        }
        return this.putContent("services", this.servicesEndpoint, services, services.size());
    }

    private boolean putContent(String type, String endpoint, Object content, int size) {
        try {
            HttpURLConnection httpCon = this.getHttpURLConnection(endpoint);
            OutputStream out = httpCon.getOutputStream();
            this.objectMapper.writeValue(out, content);
            out.flush();
            out.close();
            int responseCode = httpCon.getResponseCode();
            if (responseCode != 200) {
                if (log.isDebugEnabled()) {
                    log.debug("Error while sending {} {} to the DD agent. Status: {}, ResponseMessage: ", new Object[]{size, type, responseCode, httpCon.getResponseMessage()});
                } else if (this.loggingRateLimiter.tryAcquire()) {
                    log.warn("Error while sending {} {} to the DD agent. Status: {} (going silent for {} seconds)", new Object[]{size, type, responseCode, httpCon.getResponseMessage(), SECONDS_BETWEEN_ERROR_LOG});
                }
                return false;
            }
            log.debug("Succesfully sent {} {} to the DD agent.", (Object)size, (Object)type);
            return true;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while sending " + size + " " + type + " to the DD agent.", (Throwable)e);
            } else if (this.loggingRateLimiter.tryAcquire()) {
                log.warn("Error while sending {} {} to the DD agent. {}: {} (going silent for {} seconds)", new Object[]{size, type, e.getClass().getName(), e.getMessage(), SECONDS_BETWEEN_ERROR_LOG});
            }
            return false;
        }
    }

    private HttpURLConnection getHttpURLConnection(String endpoint) throws IOException {
        URL url = new URL(endpoint);
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("PUT");
        httpCon.setRequestProperty("Content-Type", "application/msgpack");
        httpCon.setRequestProperty("Datadog-Meta-Lang", "java");
        httpCon.setRequestProperty("Datadog-Meta-Lang-Version", DDTraceOTInfo.JAVA_VERSION);
        httpCon.setRequestProperty("Datadog-Meta-Lang-Interpreter", DDTraceOTInfo.JAVA_VM_NAME);
        httpCon.setRequestProperty("Datadog-Meta-Tracer-Version", DDTraceOTInfo.VERSION);
        return httpCon;
    }

    public String toString() {
        return "DDApi { tracesEndpoint=" + this.tracesEndpoint + " }";
    }
}

