/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import datadog.trace.common.util.ConfigUtils;
import io.opentracing.tag.Tags;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class URLAsResourceName
extends AbstractDecorator {
    public static final String CONFIG_PATH = "dd-trace";
    public static final Config.Rule RULE_QPARAM = new Config.Rule("\\?.*$", "");
    public static final Config.Rule RULE_DIGIT = new Config.Rule("\\d+", "?");
    private List<Config.Rule> patterns = new ArrayList<Config.Rule>();

    public URLAsResourceName() {
        this(CONFIG_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLAsResourceName(String configPath) {
        this.setMatchingTag(Tags.HTTP_URL.getKey());
        this.setSetTag("resource.name");
        try {
            Config config = ConfigUtils.loadConfigFromResource(configPath, Config.class);
            for (Config.Rule pattern : config.urlResourcePatterns) {
                this.patterns.add(pattern);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.patterns.add(RULE_QPARAM);
            this.patterns.add(RULE_DIGIT);
        }
    }

    @Override
    public boolean afterSetTag(DDSpanContext context, String tag, Object value) {
        try {
            String statusCode = String.valueOf(context.getTags().get(Tags.HTTP_STATUS.getKey()));
            if (statusCode != null && statusCode.equals("404")) {
                return true;
            }
            String path = String.valueOf(value);
            try {
                path = new URL(path).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            path = this.norm(path);
            String verb = (String)context.getTags().get(Tags.HTTP_METHOD.getKey());
            if (verb != null && !verb.isEmpty()) {
                path = verb + " " + path;
            }
            context.setResourceName(path);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    String norm(String origin) {
        String norm = origin;
        for (Config.Rule p : this.patterns) {
            norm = norm.replaceAll(p.regex, p.replacement);
            if (!p.isFinal) continue;
            break;
        }
        return norm;
    }

    List<Config.Rule> getPatterns() {
        return this.patterns;
    }

    void setPatterns(List<Config.Rule> patterns) {
        this.patterns = patterns;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Config {
        List<Rule> urlResourcePatterns;

        public List<Rule> getUrlResourcePatterns() {
            return this.urlResourcePatterns;
        }

        public void setUrlResourcePatterns(List<Rule> urlResourcePatterns) {
            this.urlResourcePatterns = urlResourcePatterns;
        }

        public static class Rule {
            String regex;
            String replacement;
            boolean isFinal = false;

            public Rule() {
            }

            public Rule(String regex, String replacement) {
                this.regex = regex;
                this.replacement = replacement;
            }

            public String getRegex() {
                return this.regex;
            }

            public void setRegex(String regex) {
                this.regex = regex;
            }

            public String getReplacement() {
                return this.replacement;
            }

            public void setReplacement(String replacement) {
                this.replacement = replacement;
            }

            public boolean isFinal() {
                return this.isFinal;
            }

            public void setFinal(boolean isFinal) {
                this.isFinal = isFinal;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Rule rule = (Rule)o;
                return Objects.equals(this.regex, rule.regex) && Objects.equals(this.replacement, rule.replacement);
            }

            public int hashCode() {
                return Objects.hash(this.regex, this.replacement, this.isFinal);
            }
        }
    }
}

