/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static <A> A loadConfigFromResource(String resourceName, Class<A> targetClass) {
        Object config = null;
        if (!resourceName.endsWith(".yaml") && !resourceName.endsWith(".yml")) {
            config = ConfigUtils.loadConfigFromResource(resourceName + ".yaml", targetClass);
            if (config == null) {
                config = ConfigUtils.loadConfigFromResource(resourceName + ".yml", targetClass);
            }
            if (config != null) {
                return (A)config;
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(resourceName);
            if (resource != null) {
                log.info("Loading config from resource " + resource);
                config = objectMapper.readValue(resource.openStream(), targetClass);
            }
        }
        catch (IOException e) {
            log.warn("Could not load configuration file {}.", (Object)resourceName);
            log.error("Error when loading config file", (Throwable)e);
        }
        return (A)config;
    }
}

