/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common;

import datadog.trace.common.writer.Writer;
import java.util.Properties;

public class DDTraceConfig
extends Properties {
    private static final String PREFIX = "dd.";
    public static final String SERVICE_NAME = "service.name";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String AGENT_PORT = "agent.port";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    private final String serviceName = this.getPropOrEnv("dd.service.name");
    private final String writerType = this.getPropOrEnv("dd.writer.type");
    private final String agentHost = this.getPropOrEnv("dd.agent.host");
    private final String agentPort = this.getPropOrEnv("dd.agent.port");
    private final String prioritySampling = this.getPropOrEnv("dd.priority.sampling");

    public DDTraceConfig() {
        Properties defaults = new Properties();
        defaults.setProperty(SERVICE_NAME, "unnamed-java-app");
        defaults.setProperty(WRITER_TYPE, Writer.DD_AGENT_WRITER_TYPE);
        defaults.setProperty(AGENT_HOST, "localhost");
        defaults.setProperty(AGENT_PORT, String.valueOf(8126));
        this.defaults = defaults;
        this.setIfNotNull(SERVICE_NAME, this.serviceName);
        this.setIfNotNull(WRITER_TYPE, this.writerType);
        this.setIfNotNull(AGENT_HOST, this.agentHost);
        this.setIfNotNull(AGENT_PORT, this.agentPort);
        this.setIfNotNull(PRIORITY_SAMPLING, this.prioritySampling);
    }

    public DDTraceConfig(String serviceName) {
        this();
        this.put(SERVICE_NAME, serviceName);
    }

    private void setIfNotNull(String key, String value) {
        if (value != null) {
            this.setProperty(key, value);
        }
    }

    private String getPropOrEnv(String name) {
        return System.getProperty(name, System.getenv(DDTraceConfig.propToEnvName(name)));
    }

    static String propToEnvName(String name) {
        return name.toUpperCase().replace(".", "_");
    }
}

