/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class Service {
    private final String name;
    private final String appName;
    private final AppType appType;

    public Service(String name, String appName, AppType appType) {
        this.name = name;
        this.appName = appName;
        this.appType = appType;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="app")
    public String getAppName() {
        return this.appName;
    }

    @JsonProperty(value="app_type")
    public AppType getAppType() {
        return this.appType;
    }

    public String toString() {
        return "Service { name='" + this.name + "', appName='" + this.appName + "', appType=" + (Object)((Object)this.appType) + " }";
    }

    public static enum AppType {
        WEB("web"),
        DB("db"),
        CUSTOM("custom"),
        CACHE("cache"),
        WORKER("worker");

        private final String type;

        private AppType(String type) {
            this.type = type;
        }

        @JsonValue
        public String toString() {
            return this.type;
        }
    }
}

