/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;

public class OperationDecorator
extends AbstractDecorator {
    static final Map<String, String> MAPPINGS = new HashMap<String, String>(){
        {
            this.put("apache-httpclient", "apache.http");
            this.put("java-aws-sdk", "aws.http");
            this.put("java-jms", "jms");
            this.put("okhttp", "okhttp.http");
        }
    };

    public OperationDecorator() {
        this.setMatchingTag(Tags.COMPONENT.getKey());
    }

    @Override
    public boolean afterSetTag(DDSpanContext context, String tag, Object value) {
        if (MAPPINGS.containsKey(String.valueOf(value))) {
            context.setOperationName(MAPPINGS.get(String.valueOf(value)));
            return true;
        }
        return false;
    }
}

