/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.trace.context.ScopeListener;
import io.opentracing.Scope;
import io.opentracing.Span;

public class SimpleScope
implements Scope {
    private final ContextualScopeManager scopeManager;
    private final Span spanUnderScope;
    private final boolean finishOnClose;
    private final Scope toRestore;

    public SimpleScope(ContextualScopeManager scopeManager, Span spanUnderScope, boolean finishOnClose) {
        assert (spanUnderScope != null) : "span must not be null";
        this.scopeManager = scopeManager;
        this.spanUnderScope = spanUnderScope;
        this.finishOnClose = finishOnClose;
        this.toRestore = ContextualScopeManager.tlsScope.get();
        ContextualScopeManager.tlsScope.set(this);
        for (ScopeListener listener : scopeManager.scopeListeners) {
            listener.afterScopeActivated();
        }
    }

    public void close() {
        if (this.finishOnClose) {
            this.spanUnderScope.finish();
        }
        for (ScopeListener listener : this.scopeManager.scopeListeners) {
            listener.afterScopeClosed();
        }
        if (ContextualScopeManager.tlsScope.get() == this) {
            ContextualScopeManager.tlsScope.set(this.toRestore);
            if (this.toRestore != null) {
                for (ScopeListener listener : this.scopeManager.scopeListeners) {
                    listener.afterScopeActivated();
                }
            }
        }
    }

    public Span span() {
        return this.spanUnderScope;
    }
}

