/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.HttpCodec;
import datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatadogHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(DatadogHttpCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String TRACE_ID_KEY = "x-datadog-trace-id";
    private static final String SPAN_ID_KEY = "x-datadog-parent-id";
    private static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";
    private static final String ORIGIN_KEY = "x-datadog-origin";

    private DatadogHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> baggage = Collections.emptyMap();
                Map<String, String> tags = Collections.emptyMap();
                String traceId = "0";
                String spanId = "0";
                int samplingPriority = Integer.MIN_VALUE;
                String origin = null;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase();
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (DatadogHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        traceId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (DatadogHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (DatadogHttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = Integer.parseInt(value);
                    } else if (DatadogHttpCodec.ORIGIN_KEY.equalsIgnoreCase(key)) {
                        origin = value;
                    } else if (key.startsWith(DatadogHttpCodec.OT_BAGGAGE_PREFIX)) {
                        if (baggage.isEmpty()) {
                            baggage = new HashMap<String, String>();
                        }
                        baggage.put(key.replace(DatadogHttpCodec.OT_BAGGAGE_PREFIX, ""), HttpCodec.decode(value));
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!"0".equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, origin, baggage, tags);
                    context.lockSamplingPriority();
                    log.debug("{} - Parent context extracted", (Object)context.getTraceId());
                    return context;
                }
                if (origin != null || !tags.isEmpty()) {
                    log.debug("Tags context extracted");
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException e) {
                log.debug("Exception when extracting context", (Throwable)e);
            }
            return null;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            String origin;
            carrier.put(DatadogHttpCodec.TRACE_ID_KEY, context.getTraceId());
            carrier.put(DatadogHttpCodec.SPAN_ID_KEY, context.getSpanId());
            if (context.lockSamplingPriority()) {
                carrier.put(DatadogHttpCodec.SAMPLING_PRIORITY_KEY, String.valueOf(context.getSamplingPriority()));
            }
            if ((origin = context.getOrigin()) != null) {
                carrier.put(DatadogHttpCodec.ORIGIN_KEY, origin);
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                carrier.put(DatadogHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            log.debug("{} - Datadog parent context injected", (Object)context.getTraceId());
        }
    }
}

