/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import datadog.opentracing.DDSpanContext;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.common.util.Clock;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpan
implements Span,
MutableSpan {
    private static final Logger log = LoggerFactory.getLogger(DDSpan.class);
    private final DDSpanContext context;
    private final long startTimeMicro;
    private final long startTimeNano;
    private final AtomicLong durationNano = new AtomicLong();
    volatile WeakReference<DDSpan> ref;

    DDSpan(long timestampMicro, DDSpanContext context) {
        this.context = context;
        if (timestampMicro <= 0L) {
            this.startTimeMicro = Clock.currentMicroTime();
            this.startTimeNano = context.getTrace().getCurrentTimeNano();
        } else {
            this.startTimeMicro = timestampMicro;
            this.startTimeNano = 0L;
        }
        context.getTrace().registerSpan(this);
    }

    @JsonIgnore
    public boolean isFinished() {
        return this.durationNano.get() != 0L;
    }

    private void finishAndAddToTrace(long durationNano) {
        if (this.durationNano.compareAndSet(0L, Math.max(1L, durationNano))) {
            log.debug("Finished: {}", (Object)this);
            this.context.getTrace().addSpan(this);
        } else {
            log.debug("{} - already finished!", (Object)this);
        }
    }

    public final void finish() {
        if (this.startTimeNano > 0L) {
            this.finishAndAddToTrace(this.context.getTrace().getCurrentTimeNano() - this.startTimeNano);
        } else {
            this.finish(Clock.currentMicroTime());
        }
    }

    public final void finish(long stoptimeMicros) {
        this.finishAndAddToTrace(TimeUnit.MICROSECONDS.toNanos(stoptimeMicros - this.startTimeMicro));
    }

    public DDSpan setError(boolean error) {
        this.context.setErrorFlag(true);
        return this;
    }

    @JsonIgnore
    public final boolean isRootSpan() {
        return "0".equals(this.context.getParentId());
    }

    @Deprecated
    @JsonIgnore
    public MutableSpan getRootSpan() {
        return this.getLocalRootSpan();
    }

    @JsonIgnore
    public MutableSpan getLocalRootSpan() {
        return this.context().getTrace().getRootSpan();
    }

    public void setErrorMeta(Throwable error) {
        this.setError(true);
        this.setTag("error.msg", error.getMessage());
        this.setTag("error.type", error.getClass().getName());
        StringWriter errorString = new StringWriter();
        error.printStackTrace(new PrintWriter(errorString));
        this.setTag("error.stack", errorString.toString());
    }

    private boolean extractError(Map<String, ?> map) {
        if (map.get("error.object") instanceof Throwable) {
            Throwable error = (Throwable)map.get("error.object");
            this.setErrorMeta(error);
            return true;
        }
        return false;
    }

    public final DDSpan setTag(String tag, String value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final DDSpan setTag(String tag, boolean value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final DDSpan setTag(String tag, Number value) {
        this.context().setTag(tag, value);
        return this;
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        this.context().setTag(tag.getKey(), value);
        return this;
    }

    public final DDSpanContext context() {
        return this.context;
    }

    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public final DDSpan setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this;
    }

    public final DDSpan setOperationName(String operationName) {
        this.context().setOperationName(operationName);
        return this;
    }

    public final DDSpan log(Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this;
    }

    public final DDSpan log(long l, Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this;
    }

    public final DDSpan log(String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this;
    }

    public final DDSpan log(long l, String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this;
    }

    public final DDSpan setServiceName(String serviceName) {
        this.context().setServiceName(serviceName);
        return this;
    }

    public final DDSpan setResourceName(String resourceName) {
        this.context().setResourceName(resourceName);
        return this;
    }

    public final DDSpan setSamplingPriority(int newPriority) {
        this.context().setSamplingPriority(newPriority);
        return this;
    }

    public final DDSpan setSpanType(String type) {
        this.context().setSpanType(type);
        return this;
    }

    @JsonGetter
    public Map<String, String> getMeta() {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.context().getBaggageItems().entrySet()) {
            meta.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getTags().entrySet()) {
            meta.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return meta;
    }

    @JsonGetter
    public Map<String, Number> getMetrics() {
        return this.context.getMetrics();
    }

    @JsonGetter(value="start")
    public long getStartTime() {
        return this.startTimeNano > 0L ? this.startTimeNano : TimeUnit.MICROSECONDS.toNanos(this.startTimeMicro);
    }

    @JsonGetter(value="duration")
    public long getDurationNano() {
        return this.durationNano.get();
    }

    @JsonGetter(value="service")
    public String getServiceName() {
        return this.context.getServiceName();
    }

    @JsonGetter(value="trace_id")
    @JsonSerialize(using=UInt64IDStringSerializer.class)
    public String getTraceId() {
        return this.context.getTraceId();
    }

    @JsonGetter(value="span_id")
    @JsonSerialize(using=UInt64IDStringSerializer.class)
    public String getSpanId() {
        return this.context.getSpanId();
    }

    @JsonGetter(value="parent_id")
    @JsonSerialize(using=UInt64IDStringSerializer.class)
    public String getParentId() {
        return this.context.getParentId();
    }

    @JsonGetter(value="resource")
    public String getResourceName() {
        return this.context.getResourceName();
    }

    @JsonGetter(value="name")
    public String getOperationName() {
        return this.context.getOperationName();
    }

    @JsonIgnore
    public Integer getSamplingPriority() {
        int samplingPriority = this.context.getSamplingPriority();
        if (samplingPriority == Integer.MIN_VALUE) {
            return null;
        }
        return samplingPriority;
    }

    @JsonIgnore
    public String getSpanType() {
        return this.context.getSpanType();
    }

    @JsonIgnore
    public Map<String, Object> getTags() {
        return this.context().getTags();
    }

    @JsonGetter
    public String getType() {
        return this.context.getSpanType();
    }

    @JsonIgnore
    public Boolean isError() {
        return this.context.getErrorFlag();
    }

    @JsonGetter
    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano;
    }

    protected static class UInt64IDStringSerializer
    extends StdSerializer<String> {
        private static final int LONG_PARSE_LIMIT = String.valueOf(Long.MAX_VALUE).length();

        public UInt64IDStringSerializer() {
            this(null);
        }

        public UInt64IDStringSerializer(Class<String> stringClass) {
            super(stringClass);
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            int length = value.length();
            if (length > LONG_PARSE_LIMIT || length == LONG_PARSE_LIMIT && value.startsWith("9")) {
                gen.writeNumber(new BigInteger(value));
            } else {
                gen.writeNumber(Long.parseLong(value));
            }
        }
    }
}

