/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.HttpCodec;
import datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class B3HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(B3HttpCodec.class);
    private static final String TRACE_ID_KEY = "X-B3-TraceId";
    private static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;

    private B3HttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> tags = Collections.emptyMap();
                String traceId = "0";
                String spanId = "0";
                int samplingPriority = Integer.MIN_VALUE;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase();
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        int length = value.length();
                        if (length > 32) {
                            log.debug("Header {} exceeded max length of 32: {}", (Object)B3HttpCodec.TRACE_ID_KEY, (Object)value);
                            traceId = "0";
                            continue;
                        }
                        String trimmedValue = length > 16 ? value.substring(length - 16) : value;
                        traceId = HttpCodec.validateUInt64BitsID(trimmedValue, 16);
                    } else if (B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 16);
                    } else if (B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = this.convertSamplingPriority(value);
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!"0".equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, null, Collections.emptyMap(), tags);
                    context.lockSamplingPriority();
                    log.debug("{} - Parent context extracted", (Object)context.getTraceId());
                    return context;
                }
                if (!tags.isEmpty()) {
                    log.debug("Tags context extracted");
                    return new TagContext(null, tags);
                }
            }
            catch (RuntimeException e) {
                log.debug("Exception when extracting context", (Throwable)e);
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            try {
                BigInteger traceId = new BigInteger(context.getTraceId());
                BigInteger spanId = new BigInteger(context.getSpanId());
                carrier.put(B3HttpCodec.TRACE_ID_KEY, traceId.toString(16).toLowerCase());
                carrier.put(B3HttpCodec.SPAN_ID_KEY, spanId.toString(16).toLowerCase());
                if (context.lockSamplingPriority()) {
                    carrier.put(B3HttpCodec.SAMPLING_PRIORITY_KEY, this.convertSamplingPriority(context.getSamplingPriority()));
                }
                log.debug("{} - B3 parent context injected", (Object)context.getTraceId());
            }
            catch (NumberFormatException e) {
                log.debug("Cannot parse context id(s): {} {}", new Object[]{context.getTraceId(), context.getSpanId(), e});
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

