/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.propagation.B3HttpCodec;
import datadog.opentracing.propagation.DatadogHttpCodec;
import datadog.opentracing.propagation.ExtractedContext;
import datadog.opentracing.propagation.HaystackHttpCodec;
import datadog.trace.api.Config;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HttpCodec.class);
    static final BigInteger UINT64_MAX = new BigInteger("2").pow(64).subtract(BigInteger.ONE);
    static final String ZERO = "0";

    public static Injector createInjector(Config config) {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        for (Config.PropagationStyle style : config.getPropagationStylesToInject()) {
            if (style == Config.PropagationStyle.DATADOG) {
                injectors.add(new DatadogHttpCodec.Injector());
                continue;
            }
            if (style == Config.PropagationStyle.B3) {
                injectors.add(new B3HttpCodec.Injector());
                continue;
            }
            if (style == Config.PropagationStyle.HAYSTACK) {
                injectors.add(new HaystackHttpCodec.Injector());
                continue;
            }
            log.debug("No implementation found to inject propagation style: {}", (Object)style);
        }
        return new CompoundInjector(injectors);
    }

    public static Extractor createExtractor(Config config, Map<String, String> taggedHeaders) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        for (Config.PropagationStyle style : config.getPropagationStylesToExtract()) {
            if (style == Config.PropagationStyle.DATADOG) {
                extractors.add(new DatadogHttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style == Config.PropagationStyle.B3) {
                extractors.add(new B3HttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style == Config.PropagationStyle.HAYSTACK) {
                extractors.add(new HaystackHttpCodec.Extractor(taggedHeaders));
                continue;
            }
            log.debug("No implementation found to extract propagation style: {}", (Object)style);
        }
        return new CompoundExtractor(extractors);
    }

    static String validateUInt64BitsID(String value, int radix) throws IllegalArgumentException {
        BigInteger parsedValue = new BigInteger(value, radix);
        if (parsedValue.compareTo(BigInteger.ZERO) == -1 || parsedValue.compareTo(UINT64_MAX) == 1) {
            throw new IllegalArgumentException("ID out of range, must be between 0 and 2^64-1, got: " + value);
        }
        return parsedValue.toString();
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;

        public CompoundExtractor(List<Extractor> extractors) {
            this.extractors = extractors;
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            SpanContext context = null;
            for (Extractor extractor : this.extractors) {
                context = extractor.extract(carrier);
                if (context == null || !(context instanceof ExtractedContext)) continue;
                return context;
            }
            return context;
        }
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier);
            }
        }
    }

    public static interface Extractor {
        public SpanContext extract(TextMapExtract var1);
    }

    public static interface Injector {
        public void inject(DDSpanContext var1, TextMapInject var2);
    }
}

