/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import datadog.opentracing.DDSpan;
import datadog.trace.common.sampling.AbstractSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateByServiceSampler
implements Sampler,
DDApi.ResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceSampler.class);
    private static final String DEFAULT_KEY = "service:,env:";
    private static final double DEFAULT_RATE = 1.0;
    private volatile Map<String, RateSampler> serviceRates = Collections.unmodifiableMap(Collections.singletonMap("service:,env:", new RateSampler(1.0)));

    @Override
    public boolean sample(DDSpan span) {
        return true;
    }

    public void initializeSamplingPriority(DDSpan span) {
        if (span.isRootSpan()) {
            this.setSamplingPriorityOnSpanContext(span);
        } else if (span.getSamplingPriority() == null) {
            this.setSamplingPriorityOnSpanContext(span);
        }
    }

    private void setSamplingPriorityOnSpanContext(DDSpan span) {
        String serviceName = span.getServiceName();
        String env = RateByServiceSampler.getSpanEnv(span);
        String key = "service:" + serviceName + ",env:" + env;
        Map<String, RateSampler> rates = this.serviceRates;
        RateSampler sampler = this.serviceRates.get(key);
        if (sampler == null) {
            sampler = rates.get(DEFAULT_KEY);
        }
        if (sampler.sample(span)) {
            span.setSamplingPriority(1);
        } else {
            span.setSamplingPriority(0);
        }
    }

    private static String getSpanEnv(DDSpan span) {
        return null == span.getTags().get("env") ? "" : String.valueOf(span.getTags().get("env"));
    }

    @Override
    public void onResponse(String endpoint, JsonNode responseJson) {
        JsonNode newServiceRates = responseJson.get("rate_by_service");
        if (null != newServiceRates) {
            log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, (Object)responseJson);
            HashMap<String, RateSampler> updatedServiceRates = new HashMap<String, RateSampler>();
            Iterator itr = newServiceRates.fieldNames();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                JsonNode value = newServiceRates.get(key);
                try {
                    if (value instanceof NumericNode) {
                        updatedServiceRates.put(key, new RateSampler(value.doubleValue()));
                        continue;
                    }
                    log.debug("Unable to parse new service rate {} -> {}", (Object)key, (Object)value);
                }
                catch (NumberFormatException nfe) {
                    log.debug("Unable to parse new service rate {} -> {}", (Object)key, (Object)value);
                }
            }
            if (!updatedServiceRates.containsKey(DEFAULT_KEY)) {
                updatedServiceRates.put(DEFAULT_KEY, new RateSampler(1.0));
            }
            this.serviceRates = Collections.unmodifiableMap(updatedServiceRates);
        }
    }

    private static class RateSampler
    extends AbstractSampler {
        private final double sampleRate;

        private RateSampler(double sampleRate) {
            if (sampleRate < 0.0) {
                sampleRate = 1.0;
                log.error("SampleRate is negative or null, disabling the sampler");
            } else if (sampleRate > 1.0) {
                sampleRate = 1.0;
            }
            this.sampleRate = sampleRate;
            log.debug("Initializing the RateSampler, sampleRate: {} %", (Object)(this.sampleRate * 100.0));
        }

        @Override
        public boolean doSample(DDSpan span) {
            boolean sample = (double)ThreadLocalRandom.current().nextFloat() <= this.sampleRate;
            log.debug("{} - Span is sampled: {}", (Object)span, (Object)sample);
            return sample;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public String toString() {
            return "RateSampler { sampleRate=" + this.sampleRate + " }";
        }
    }
}

