/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.api.Config;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.DDApi;
import datadog.trace.common.writer.LoggingWriter;
import java.io.Closeable;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Writer
extends Closeable {
    public void write(List<DDSpan> var1);

    public void start();

    @Override
    public void close();

    public void incrementTraceCount();

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Writer forConfig(Config config) {
            Writer writer;
            if (config != null) {
                String configuredType = config.getWriterType();
                if ("DDAgentWriter".equals(configuredType)) {
                    writer = Builder.createAgentWriter(config);
                } else if ("LoggingWriter".equals(configuredType)) {
                    writer = new LoggingWriter();
                } else {
                    log.warn("Writer type not configured correctly: Type {} not recognized. Defaulting to DDAgentWriter.", (Object)configuredType);
                    writer = Builder.createAgentWriter(config);
                }
            } else {
                log.warn("Writer type not configured correctly: No config provided! Defaulting to DDAgentWriter.");
                writer = new DDAgentWriter();
            }
            return writer;
        }

        public static Writer forConfig(Properties config) {
            return Builder.forConfig(Config.get((Properties)config));
        }

        private static Writer createAgentWriter(Config config) {
            return new DDAgentWriter(Builder.createApi(config), Builder.createMonitor(config));
        }

        private static final DDApi createApi(Config config) {
            return new DDApi(config.getAgentHost(), config.getAgentPort(), config.getAgentUnixDomainSocket());
        }

        private static final DDAgentWriter.Monitor createMonitor(Config config) {
            Integer port;
            if (!config.isHealthMetricsEnabled()) {
                return new DDAgentWriter.NoopMonitor();
            }
            String host = config.getHealthMetricsStatsdHost();
            if (host == null) {
                host = config.getJmxFetchStatsdHost();
            }
            if (host == null) {
                host = config.getAgentHost();
            }
            if ((port = config.getHealthMetricsStatsdPort()) == null) {
                port = config.getJmxFetchStatsdPort();
            }
            return new DDAgentWriter.StatsDMonitor(host, port);
        }

        private Builder() {
        }
    }
}

