/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import datadog.opentracing.DDSpanContext;
import datadog.trace.common.util.Clock;
import io.opentracing.Span;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpan
implements Span {
    private static final Logger log = LoggerFactory.getLogger(DDSpan.class);
    private final DDSpanContext context;
    private final long startTimeMicro;
    private final long startTimeNano;
    private volatile long durationNano;

    DDSpan(long timestampMicro, DDSpanContext context) {
        this.context = context;
        if (timestampMicro <= 0L) {
            this.startTimeMicro = Clock.currentMicroTime();
            this.startTimeNano = Clock.currentNanoTicks();
        } else {
            this.startTimeMicro = timestampMicro;
            this.startTimeNano = 0L;
        }
        this.context.getTrace().add(this);
    }

    public final void finish() {
        if (this.startTimeNano != 0L) {
            if (this.durationNano != 0L) {
                log.debug("Span already finished: {}", (Object)this);
            }
            this.durationNano = Math.max(1L, Clock.currentNanoTicks() - this.startTimeNano);
            this.afterFinish();
        } else {
            this.finish(Clock.currentMicroTime());
        }
    }

    public final void finish(long stoptimeMicros) {
        if (this.durationNano != 0L) {
            log.debug("Span already finished: {}", (Object)this);
        }
        this.durationNano = Math.max(1L, TimeUnit.MICROSECONDS.toNanos(stoptimeMicros - this.startTimeMicro));
        this.afterFinish();
    }

    protected final void afterFinish() {
        log.debug("{} - Closing the span.", (Object)this);
        if (this.isRootSpan()) {
            Queue<DDSpan> spans = this.context().getTrace();
            for (DDSpan span : spans) {
                if (span.getDurationNano() != 0L) continue;
                log.warn("{} - The parent span is marked as finished but this span isn't. You have to close each children.", (Object)this);
            }
            this.context.getTracer().write(this.context.getTrace());
            log.debug("{} - Write the trace", (Object)this);
        }
    }

    @JsonIgnore
    public final boolean isRootSpan() {
        if (this.context().getTrace().isEmpty()) {
            return false;
        }
        DDSpan first = this.context().getTrace().peek();
        return first.context().getSpanId() == this.context().getSpanId() && this.context.getTracer() != null;
    }

    public void setErrorMeta(Throwable error) {
        this.context.setErrorFlag(true);
        this.setTag("error.msg", error.getMessage());
        this.setTag("error.type", error.getClass().getName());
        StringWriter errorString = new StringWriter();
        error.printStackTrace(new PrintWriter(errorString));
        this.setTag("error.stack", errorString.toString());
    }

    private boolean extractError(Map<String, ?> map) {
        if (map.get("error.object") instanceof Throwable) {
            Throwable error = (Throwable)map.get("error.object");
            this.setErrorMeta(error);
            return true;
        }
        return false;
    }

    public final Span setTag(String tag, String value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final Span setTag(String tag, boolean value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final Span setTag(String tag, Number value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final DDSpanContext context() {
        return this.context;
    }

    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public final DDSpan setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this;
    }

    public final DDSpan setOperationName(String operationName) {
        this.context().setOperationName(operationName);
        return this;
    }

    public final DDSpan log(Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this;
    }

    public final DDSpan log(long l, Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this;
    }

    public final DDSpan log(String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this;
    }

    public final DDSpan log(long l, String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this;
    }

    public final DDSpan setServiceName(String serviceName) {
        this.context().setServiceName(serviceName);
        return this;
    }

    public final DDSpan setResourceName(String resourceName) {
        this.context().setResourceName(resourceName);
        return this;
    }

    public final DDSpan setSamplingPriority(int newPriority) {
        this.context().setSamplingPriority(newPriority);
        return this;
    }

    public final DDSpan setSpanType(String type) {
        this.context().setSpanType(type);
        return this;
    }

    @JsonGetter
    public Map<String, String> getMeta() {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.context().getBaggageItems().entrySet()) {
            meta.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getTags().entrySet()) {
            meta.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return meta;
    }

    @JsonGetter(value="start")
    public long getStartTime() {
        return this.startTimeMicro * 1000L;
    }

    @JsonGetter(value="duration")
    public long getDurationNano() {
        return this.durationNano;
    }

    @JsonGetter(value="service")
    public String getServiceName() {
        return this.context.getServiceName();
    }

    @JsonGetter(value="trace_id")
    public long getTraceId() {
        return this.context.getTraceId();
    }

    @JsonGetter(value="span_id")
    public long getSpanId() {
        return this.context.getSpanId();
    }

    @JsonGetter(value="parent_id")
    public long getParentId() {
        return this.context.getParentId();
    }

    @JsonGetter(value="resource")
    public String getResourceName() {
        return this.context.getResourceName();
    }

    @JsonGetter(value="name")
    public String getOperationName() {
        return this.context.getOperationName();
    }

    @JsonGetter(value="sampling_priority")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getSamplingPriority() {
        int samplingPriority = this.context.getSamplingPriority();
        if (samplingPriority == Integer.MIN_VALUE) {
            return null;
        }
        return samplingPriority;
    }

    @JsonIgnore
    public Map<String, Object> getTags() {
        return this.context().getTags();
    }

    @JsonGetter
    public String getType() {
        return this.context.getSpanType();
    }

    @JsonGetter
    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano;
    }
}

