/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;

public class DBTypeDecorator
extends AbstractDecorator {
    public DBTypeDecorator() {
        this.setMatchingTag(Tags.DB_TYPE.getKey());
        this.setSetTag("service.name");
    }

    @Override
    public boolean afterSetTag(DDSpanContext context, String tag, Object value) {
        if (super.afterSetTag(context, tag, value)) {
            if ("mongo".equals(value)) {
                context.setSpanType("mongodb");
            } else if ("cassandra".equals(value)) {
                context.setSpanType("cassandra");
            } else {
                context.setSpanType("sql");
            }
            context.setOperationName(String.valueOf(value) + ".query");
            return true;
        }
        return false;
    }
}

