/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class URLAsResourceName
extends AbstractDecorator {
    public static final Pattern QUERYSTRING = Pattern.compile("\\?.*$");
    public static final Pattern PATH_MIXED_ALPHANUMERICS = Pattern.compile("(?<=/)(?![vV]\\d{1,2}/)(?:[^\\/\\d\\?]*[\\d]+[^\\/\\?]*)");

    public URLAsResourceName() {
        this.setMatchingTag(Tags.HTTP_URL.getKey());
        this.setSetTag("resource.name");
    }

    @Override
    public boolean afterSetTag(DDSpanContext context, String tag, Object value) {
        try {
            String statusCode = String.valueOf(context.getTags().get(Tags.HTTP_STATUS.getKey()));
            if (statusCode != null && statusCode.equals("404")) {
                return true;
            }
            String path = String.valueOf(value);
            try {
                path = new URL(path).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            path = this.norm(path);
            String verb = (String)context.getTags().get(Tags.HTTP_METHOD.getKey());
            if (verb != null && !verb.isEmpty()) {
                path = verb + " " + path;
            }
            context.setResourceName(path);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    private String norm(String origin) {
        String norm = origin;
        norm = QUERYSTRING.matcher(norm).replaceAll("");
        norm = PATH_MIXED_ALPHANUMERICS.matcher(norm).replaceAll("?");
        return norm;
    }
}

