/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.DDSpan;
import datadog.opentracing.DDSpanContext;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.scopemanager.ContextualScopeManager;
import datadog.opentracing.scopemanager.DDScope;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScope
implements DDScope,
TraceScope {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScope.class);
    private final ContextualScopeManager scopeManager;
    private final DDSpan spanUnderScope;
    private final boolean finishOnClose;
    private final AtomicInteger openCount;
    private final DDScope toRestore;
    private final Continuation continuation;
    private final AtomicBoolean isAsyncPropagating = new AtomicBoolean(false);

    ContinuableScope(ContextualScopeManager scopeManager, DDSpan spanUnderScope, boolean finishOnClose) {
        this(scopeManager, new AtomicInteger(1), null, spanUnderScope, finishOnClose);
    }

    private ContinuableScope(ContextualScopeManager scopeManager, AtomicInteger openCount, Continuation continuation, DDSpan spanUnderScope, boolean finishOnClose) {
        assert (spanUnderScope != null) : "span must not be null";
        this.scopeManager = scopeManager;
        this.openCount = openCount;
        this.continuation = continuation;
        this.spanUnderScope = spanUnderScope;
        this.finishOnClose = finishOnClose;
        this.toRestore = ContextualScopeManager.tlsScope.get();
        ContextualScopeManager.tlsScope.set(this);
        for (ScopeListener listener : scopeManager.scopeListeners) {
            listener.afterScopeActivated();
        }
    }

    public void close() {
        if (null != this.continuation) {
            this.spanUnderScope.context().getTrace().cancelContinuation(this.continuation);
        }
        if (this.openCount.decrementAndGet() == 0 && this.finishOnClose) {
            this.spanUnderScope.finish();
        }
        for (ScopeListener listener : this.scopeManager.scopeListeners) {
            listener.afterScopeClosed();
        }
        if (ContextualScopeManager.tlsScope.get() == this) {
            ContextualScopeManager.tlsScope.set(this.toRestore);
            if (this.toRestore != null) {
                for (ScopeListener listener : this.scopeManager.scopeListeners) {
                    listener.afterScopeActivated();
                }
            }
        } else {
            log.debug("Tried to close {} scope when {} is on top. Ignoring!", (Object)this, (Object)ContextualScopeManager.tlsScope.get());
        }
    }

    @Override
    public DDSpan span() {
        return this.spanUnderScope;
    }

    public boolean isAsyncPropagating() {
        return this.isAsyncPropagating.get();
    }

    public void setAsyncPropagation(boolean value) {
        this.isAsyncPropagating.set(value);
    }

    public Continuation capture() {
        if (this.isAsyncPropagating()) {
            return new Continuation();
        }
        return null;
    }

    public String toString() {
        return super.toString() + "->" + this.spanUnderScope;
    }

    public class Continuation
    implements Closeable,
    TraceScope.Continuation {
        public WeakReference<Continuation> ref;
        private final AtomicBoolean used = new AtomicBoolean(false);
        private final PendingTrace trace;

        private Continuation() {
            ContinuableScope.this.openCount.incrementAndGet();
            DDSpanContext context = ContinuableScope.this.spanUnderScope.context();
            this.trace = context.getTrace();
            this.trace.registerContinuation(this);
        }

        public ContinuableScope activate() {
            if (this.used.compareAndSet(false, true)) {
                ContinuableScope scope = new ContinuableScope(ContinuableScope.this.scopeManager, ContinuableScope.this.openCount, this, ContinuableScope.this.spanUnderScope, ContinuableScope.this.finishOnClose);
                log.debug("Activating continuation {}, scope: {}", (Object)this, (Object)scope);
                return scope;
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed.  Returning a new scope. Spans will not be linked.");
            return new ContinuableScope(ContinuableScope.this.scopeManager, new AtomicInteger(1), null, ContinuableScope.this.spanUnderScope, ContinuableScope.this.finishOnClose);
        }

        @Override
        public void close() {
            this.close(true);
        }

        public void close(boolean closeContinuationScope) {
            if (this.used.compareAndSet(false, true)) {
                this.trace.cancelContinuation(this);
                if (closeContinuationScope) {
                    ContinuableScope.this.close();
                } else if (ContinuableScope.this.openCount.decrementAndGet() == 0 && ContinuableScope.this.finishOnClose) {
                    ContinuableScope.this.spanUnderScope.finish();
                }
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }
    }
}

