/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.opentracing.DDSpan;
import datadog.trace.common.sampling.RateSampler;
import java.util.regex.Pattern;

public abstract class SamplingRule {
    private final RateSampler sampler;

    public SamplingRule(RateSampler sampler) {
        this.sampler = sampler;
    }

    public abstract boolean matches(DDSpan var1);

    public boolean sample(DDSpan span) {
        return this.sampler.sample(span);
    }

    public RateSampler getSampler() {
        return this.sampler;
    }

    public static class OperationSamplingRule
    extends PatternMatchSamplingRule {
        public OperationSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected String getRelevantString(DDSpan span) {
            return span.getOperationName();
        }
    }

    public static class ServiceSamplingRule
    extends PatternMatchSamplingRule {
        public ServiceSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected String getRelevantString(DDSpan span) {
            return span.getServiceName();
        }
    }

    public static abstract class PatternMatchSamplingRule
    extends SamplingRule {
        private final Pattern pattern;

        public PatternMatchSamplingRule(String regex, RateSampler sampler) {
            super(sampler);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(DDSpan span) {
            String relevantString = this.getRelevantString(span);
            return relevantString != null && this.pattern.matcher(relevantString).matches();
        }

        protected abstract String getRelevantString(DDSpan var1);
    }

    public static class AlwaysMatchesSamplingRule
    extends SamplingRule {
        public AlwaysMatchesSamplingRule(RateSampler sampler) {
            super(sampler);
        }

        @Override
        public boolean matches(DDSpan span) {
            return true;
        }
    }
}

