/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import datadog.opentracing.ContainerInfo;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTraceOTInfo;
import datadog.trace.common.writer.unixdomainsockets.UnixDomainSocketFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDApi {
    private static final Logger log = LoggerFactory.getLogger(DDApi.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final int HTTP_TIMEOUT = 1;
    private static final String TRACES_ENDPOINT_V3 = "v0.3/traces";
    private static final String TRACES_ENDPOINT_V4 = "v0.4/traces";
    private static final long MILLISECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toMillis(5L);
    private final List<ResponseListener> responseListeners = new ArrayList<ResponseListener>();
    private volatile long nextAllowedLogTime = 0L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private final OkHttpClient httpClient;
    private final HttpUrl tracesUrl;

    public DDApi(String host, int port, String unixDomainSocketPath) {
        this(host, port, DDApi.traceEndpointAvailable(DDApi.getUrl(host, port, TRACES_ENDPOINT_V4), unixDomainSocketPath), unixDomainSocketPath);
    }

    DDApi(String host, int port, boolean v4EndpointsAvailable, String unixDomainSocketPath) {
        this.httpClient = DDApi.buildHttpClient(unixDomainSocketPath);
        if (v4EndpointsAvailable) {
            this.tracesUrl = DDApi.getUrl(host, port, TRACES_ENDPOINT_V4);
        } else {
            log.debug("API v0.4 endpoints not available. Downgrading to v0.3");
            this.tracesUrl = DDApi.getUrl(host, port, TRACES_ENDPOINT_V3);
        }
    }

    public void addResponseListener(ResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    public Response sendTraces(List<List<DDSpan>> traces) {
        ArrayList<byte[]> serializedTraces = new ArrayList<byte[]>(traces.size());
        int sizeInBytes = 0;
        for (List<DDSpan> trace : traces) {
            try {
                byte[] serializedTrace = this.serializeTrace(trace);
                sizeInBytes += serializedTrace.length;
                serializedTraces.add(serializedTrace);
            }
            catch (JsonProcessingException e) {
                log.warn("Error serializing trace", (Throwable)e);
            }
        }
        return this.sendSerializedTraces(serializedTraces.size(), sizeInBytes, serializedTraces);
    }

    byte[] serializeTrace(List<DDSpan> trace) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(trace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Response sendSerializedTraces(int representativeCount, final Integer sizeInBytes, final List<byte[]> traces) {
        try {
            RequestBody body = new RequestBody(){

                public MediaType contentType() {
                    return MSGPACK;
                }

                public long contentLength() {
                    int traceCount = traces.size();
                    if (traceCount < 16) {
                        return sizeInBytes + 1;
                    }
                    if (traceCount < 65536) {
                        return sizeInBytes + 3;
                    }
                    return sizeInBytes + 5;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    OutputStream out = sink.outputStream();
                    MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
                    packer.packArrayHeader(traces.size());
                    for (byte[] trace : traces) {
                        packer.writePayload(trace);
                    }
                    packer.close();
                    out.close();
                }
            };
            Request request = DDApi.prepareRequest(this.tracesUrl).addHeader(X_DATADOG_TRACE_COUNT, String.valueOf(representativeCount)).put(body).build();
            try (okhttp3.Response response = this.httpClient.newCall(request).execute();){
                if (response.code() != 200) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error while sending {} of {} traces to the DD agent. Status: {}, Response: {}, Body: {}", new Object[]{traces.size(), representativeCount, response.code(), response.message(), response.body().string()});
                    } else if (this.nextAllowedLogTime < System.currentTimeMillis()) {
                        this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
                        log.warn("Error while sending {} of {} traces to the DD agent. Status: {} {} (going silent for {} minutes)", new Object[]{traces.size(), representativeCount, response.code(), response.message(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
                    }
                    Response response2 = Response.failed(response.code());
                    return response2;
                }
                log.debug("Successfully sent {} of {} traces to the DD agent.", (Object)traces.size(), (Object)representativeCount);
                String responseString = response.body().string().trim();
                try {
                    if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                        JsonNode parsedResponse = OBJECT_MAPPER.readTree(responseString);
                        String endpoint = this.tracesUrl.toString();
                        Object object = this.responseListeners.iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                object = Response.success(response.code(), parsedResponse);
                                return object;
                            }
                            ResponseListener listener = object.next();
                            listener.onResponse(endpoint, parsedResponse);
                        }
                    }
                }
                catch (JsonParseException e) {
                    log.debug("Failed to parse DD agent response: " + responseString, (Throwable)e);
                    Response response3 = Response.success(response.code(), e);
                    return response3;
                }
                Response parsedResponse = Response.success(response.code());
                return parsedResponse;
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while sending " + traces.size() + " of " + representativeCount + " traces to the DD agent.", (Throwable)e);
                return Response.failed(e);
            }
            if (this.nextAllowedLogTime >= System.currentTimeMillis()) return Response.failed(e);
            this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
            log.warn("Error while sending {} of {} traces to the DD agent. {}: {} (going silent for {} minutes)", new Object[]{traces.size(), representativeCount, e.getClass().getName(), e.getMessage(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
            return Response.failed(e);
        }
    }

    private static boolean traceEndpointAvailable(HttpUrl url, String unixDomainSocketPath) {
        return DDApi.endpointAvailable(url, unixDomainSocketPath, Collections.emptyList(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean endpointAvailable(HttpUrl url, String unixDomainSocketPath, Object data, boolean retry) {
        try {
            OkHttpClient client = DDApi.buildHttpClient(unixDomainSocketPath);
            RequestBody body = RequestBody.create((MediaType)MSGPACK, (byte[])OBJECT_MAPPER.writeValueAsBytes(data));
            Request request = DDApi.prepareRequest(url).put(body).build();
            try (okhttp3.Response response = client.newCall(request).execute();){
                boolean bl = response.code() == 200;
                return bl;
            }
        }
        catch (IOException e) {
            if (!retry) return false;
            return DDApi.endpointAvailable(url, unixDomainSocketPath, data, false);
        }
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder = builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        return builder.connectTimeout(1L, TimeUnit.SECONDS).writeTimeout(1L, TimeUnit.SECONDS).readTimeout(1L, TimeUnit.SECONDS).build();
    }

    private static HttpUrl getUrl(String host, int port, String endPoint) {
        return new HttpUrl.Builder().scheme("http").host(host).port(port).addEncodedPathSegments(endPoint).build();
    }

    private static Request.Builder prepareRequest(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, DDTraceOTInfo.JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, DDTraceOTInfo.JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, DDTraceOTInfo.JAVA_VM_VENDOR).addHeader(DATADOG_META_TRACER_VERSION, DDTraceOTInfo.VERSION);
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId == null) {
            return builder;
        }
        return builder.addHeader(DATADOG_CONTAINER_ID, containerId);
    }

    public String toString() {
        return "DDApi { tracesUrl=" + this.tracesUrl + " }";
    }

    public static interface ResponseListener {
        public void onResponse(String var1, JsonNode var2);
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final JsonNode json;
        private final Throwable exception;

        public static final Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static final Response success(int status, JsonNode json) {
            return new Response(true, status, json, null);
        }

        public static final Response success(int status, Throwable exception) {
            return new Response(true, status, null, exception);
        }

        public static final Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static final Response failed(Throwable exception) {
            return new Response(false, null, null, exception);
        }

        private Response(boolean success, Integer status, JsonNode json, Throwable exception) {
            this.success = success;
            this.status = status;
            this.json = json;
            this.exception = exception;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final JsonNode json() {
            return this.json;
        }

        public final Throwable exception() {
            return this.exception;
        }
    }
}

