/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;
import java.util.regex.Pattern;

public class URLAsResourceName
extends AbstractDecorator {
    public static final Pattern PATH_MIXED_ALPHANUMERICS = Pattern.compile("(?<=/)(?![vV]\\d{1,2}/)(?:[^\\/\\d\\?]*[\\d]+[^\\/\\?]*)");

    public URLAsResourceName() {
        this.setMatchingTag(Tags.HTTP_URL.getKey());
        this.setReplacementTag("resource.name");
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        String statusCode = String.valueOf(context.getTags().get(Tags.HTTP_STATUS.getKey()));
        if (value == null || statusCode != null && statusCode.equals("404")) {
            return true;
        }
        String rawPath = this.rawPathFromUrlString(String.valueOf(value).trim());
        String normalizedPath = this.normalizePath(rawPath);
        String resourceName = this.addMethodIfAvailable(context, normalizedPath);
        context.setResourceName(resourceName);
        return true;
    }

    private String rawPathFromUrlString(String url) {
        if (url.isEmpty()) {
            return "/";
        }
        int queryLoc = url.indexOf("?");
        int fragmentLoc = url.indexOf("#");
        int endLoc = queryLoc < 0 ? (fragmentLoc < 0 ? url.length() : fragmentLoc) : (fragmentLoc < 0 ? queryLoc : Math.min(queryLoc, fragmentLoc));
        int protoLoc = url.indexOf("://");
        if (protoLoc < 0) {
            return url.substring(0, endLoc);
        }
        int pathLoc = url.indexOf("/", protoLoc + 3);
        if (pathLoc < 0) {
            return "/";
        }
        if (queryLoc < 0) {
            return url.substring(pathLoc);
        }
        return url.substring(pathLoc, endLoc);
    }

    private String normalizePath(String path) {
        if (path.isEmpty() || path.equals("/")) {
            return "/";
        }
        return PATH_MIXED_ALPHANUMERICS.matcher(path).replaceAll("?");
    }

    private String addMethodIfAvailable(DDSpanContext context, String path) {
        String verb = (String)context.getTags().get(Tags.HTTP_METHOD.getKey());
        if (verb != null && !verb.isEmpty()) {
            path = verb + " " + path;
        }
        return path;
    }
}

