/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.api.Config;
import datadog.trace.common.util.DaemonThreadFactory;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Monitor;
import datadog.trace.common.writer.ddagent.TraceConsumer;
import datadog.trace.common.writer.ddagent.TraceSerializingDisruptor;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DDAgentWriter.class);
    private static final int DISRUPTOR_BUFFER_SIZE = 1024;
    private static final int SENDER_QUEUE_SIZE = 16;
    private static final int FLUSH_PAYLOAD_DELAY = 1;
    private static final ThreadFactory SCHEDULED_FLUSH_THREAD_FACTORY = new DaemonThreadFactory("dd-trace-writer");
    private final DDAgentApi api;
    public final int flushFrequencySeconds;
    public final TraceSerializingDisruptor disruptor;
    public final ScheduledExecutorService scheduledWriterExecutor;
    private final AtomicInteger traceCount = new AtomicInteger(0);
    public final Phaser apiPhaser = new Phaser();
    public final Monitor monitor;

    public DDAgentWriter() {
        this(new DDAgentApi("localhost", 8126, Config.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET), new Monitor.Noop());
    }

    public DDAgentWriter(DDAgentApi api, Monitor monitor) {
        this(api, monitor, 1024, 16, 1);
    }

    private DDAgentWriter(DDAgentApi api) {
        this(api, new Monitor.Noop());
    }

    private DDAgentWriter(DDAgentApi api, int disruptorSize, int senderQueueSize, int flushFrequencySeconds) {
        this(api, new Monitor.Noop(), disruptorSize, senderQueueSize, flushFrequencySeconds);
    }

    private DDAgentWriter(DDAgentApi api, Monitor monitor, int disruptorSize, int flushFrequencySeconds) {
        this(api, monitor, disruptorSize, 16, flushFrequencySeconds);
    }

    private DDAgentWriter(DDAgentApi api, int disruptorSize, int flushFrequencySeconds) {
        this(api, new Monitor.Noop(), disruptorSize, 16, flushFrequencySeconds);
    }

    private DDAgentWriter(DDAgentApi api, Monitor monitor, int disruptorSize, int senderQueueSize, int flushFrequencySeconds) {
        this.api = api;
        this.monitor = monitor;
        this.disruptor = new TraceSerializingDisruptor(disruptorSize, this, new TraceConsumer(this.traceCount, senderQueueSize, this));
        this.flushFrequencySeconds = flushFrequencySeconds;
        this.scheduledWriterExecutor = Executors.newScheduledThreadPool(1, SCHEDULED_FLUSH_THREAD_FACTORY);
        this.apiPhaser.register();
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        this.api.addResponseListener(listener);
    }

    public final long getDisruptorCapacity() {
        return this.disruptor.getDisruptorCapacity();
    }

    public final long getDisruptorUtilizedCapacity() {
        return this.getDisruptorCapacity() - this.getDisruptorRemainingCapacity();
    }

    public final long getDisruptorRemainingCapacity() {
        return this.disruptor.getDisruptorRemainingCapacity();
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (this.disruptor.running) {
            boolean published = this.disruptor.tryPublish(trace);
            if (published) {
                this.monitor.onPublish(this, trace);
            } else {
                this.traceCount.incrementAndGet();
                log.debug("Trace written to overfilled buffer. Counted but dropping trace: {}", trace);
                this.monitor.onFailedPublish(this, trace);
            }
        } else {
            log.debug("Trace written after shutdown. Ignoring trace: {}", trace);
            this.monitor.onFailedPublish(this, trace);
        }
    }

    @Override
    public void incrementTraceCount() {
        this.traceCount.incrementAndGet();
    }

    public DDAgentApi getApi() {
        return this.api;
    }

    @Override
    public void start() {
        this.disruptor.start();
        this.monitor.onStart(this);
    }

    @Override
    public void close() {
        boolean flushSuccess = true;
        this.scheduledWriterExecutor.shutdown();
        try {
            this.scheduledWriterExecutor.awaitTermination(this.flushFrequencySeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Waiting for flush executor shutdown interrupted.", (Throwable)e);
            flushSuccess = false;
        }
        this.disruptor.close();
        this.monitor.onShutdown(this, flushSuccess |= this.disruptor.flush());
    }

    public String toString() {
        String str = "DDAgentWriter { api=" + this.api;
        if (!(this.monitor instanceof Monitor.Noop)) {
            str = str + ", monitor=" + this.monitor;
        }
        str = str + " }";
        return str;
    }
}

