/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import datadog.opentracing.DDSpan;
import datadog.trace.common.util.DaemonThreadFactory;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.ddagent.DisruptorEvent;
import datadog.trace.common.writer.ddagent.TraceConsumer;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSerializingDisruptor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TraceSerializingDisruptor.class);
    private static final ThreadFactory DISRUPTOR_THREAD_FACTORY = new DaemonThreadFactory("dd-trace-disruptor");
    private final FlushTask flushTask = new FlushTask();
    private final Disruptor<DisruptorEvent<List<DDSpan>>> disruptor;
    private final DDAgentWriter writer;
    public volatile boolean running = false;
    private final AtomicReference<ScheduledFuture<?>> flushSchedule = new AtomicReference();

    public TraceSerializingDisruptor(int disruptorSize, DDAgentWriter writer, TraceConsumer handler) {
        this.disruptor = new Disruptor(new DisruptorEvent.Factory(), Math.max(2, Integer.highestOneBit(disruptorSize - 1) << 1), DISRUPTOR_THREAD_FACTORY, ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy(0, TimeUnit.MILLISECONDS.toNanos(5L)));
        this.writer = writer;
        this.disruptor.handleEventsWith(new EventHandler[]{handler});
    }

    public void start() {
        this.disruptor.start();
        this.running = true;
        this.scheduleFlush();
    }

    @Override
    public void close() {
        this.running = false;
        this.disruptor.shutdown();
    }

    public boolean tryPublish(List<DDSpan> trace) {
        return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslatorOneArg)DisruptorEvent.TraceTranslator.TRACE_TRANSLATOR, trace);
    }

    public boolean flush() {
        if (this.running) {
            log.info("Flushing any remaining traces.");
            this.writer.apiPhaser.register();
            this.disruptor.publishEvent((EventTranslator)DisruptorEvent.FlushTranslator.FLUSH_TRANSLATOR);
            try {
                this.writer.apiPhaser.awaitAdvanceInterruptibly(this.writer.apiPhaser.arriveAndDeregister());
                return true;
            }
            catch (InterruptedException e) {
                log.warn("Waiting for flush interrupted.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void scheduleFlush() {
        if (this.writer.flushFrequencySeconds > 0 && !this.writer.scheduledWriterExecutor.isShutdown()) {
            boolean previousIncomplete;
            ScheduledFuture<?> previous = this.flushSchedule.getAndSet(this.writer.scheduledWriterExecutor.schedule(this.flushTask, (long)this.writer.flushFrequencySeconds, TimeUnit.SECONDS));
            boolean bl = previousIncomplete = previous != null;
            if (previousIncomplete) {
                previous.cancel(true);
            }
            this.writer.monitor.onScheduleFlush(this.writer, previousIncomplete);
        }
    }

    public final long getDisruptorCapacity() {
        return this.disruptor.getRingBuffer().getBufferSize();
    }

    public final long getDisruptorRemainingCapacity() {
        return this.disruptor.getRingBuffer().remainingCapacity();
    }

    private class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        @Override
        public void run() {
            TraceSerializingDisruptor.this.disruptor.publishEvent((EventTranslator)DisruptorEvent.FlushTranslator.FLUSH_TRANSLATOR);
        }
    }
}

