/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.decorators.AbstractDecorator;
import datadog.opentracing.decorators.AnalyticsSampleRateDecorator;
import datadog.opentracing.decorators.DBStatementAsResourceName;
import datadog.opentracing.decorators.DBTypeDecorator;
import datadog.opentracing.decorators.ErrorFlag;
import datadog.opentracing.decorators.ForceManualDropDecorator;
import datadog.opentracing.decorators.ForceManualKeepDecorator;
import datadog.opentracing.decorators.OperationDecorator;
import datadog.opentracing.decorators.PeerServiceDecorator;
import datadog.opentracing.decorators.ResourceNameDecorator;
import datadog.opentracing.decorators.ServiceNameDecorator;
import datadog.opentracing.decorators.ServletContextDecorator;
import datadog.opentracing.decorators.SpanTypeDecorator;
import datadog.opentracing.decorators.Status404Decorator;
import datadog.opentracing.decorators.Status5XXDecorator;
import datadog.opentracing.decorators.URLAsResourceName;
import datadog.trace.api.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDDecoratorsFactory {
    private static final Logger log = LoggerFactory.getLogger(DDDecoratorsFactory.class);

    public static List<AbstractDecorator> createBuiltinDecorators() {
        ArrayList<AbstractDecorator> decorators = new ArrayList<AbstractDecorator>();
        for (AbstractDecorator decorator : Arrays.asList(new AnalyticsSampleRateDecorator(), new DBStatementAsResourceName(), new DBTypeDecorator(), new ErrorFlag(), new ForceManualDropDecorator(), new ForceManualKeepDecorator(), new OperationDecorator(), new PeerServiceDecorator(), new ResourceNameDecorator(), new ServiceNameDecorator(), new ServiceNameDecorator("service", false), new ServletContextDecorator(), new SpanTypeDecorator(), new Status404Decorator(), new Status5XXDecorator(), new URLAsResourceName())) {
            if (Config.get().isDecoratorEnabled(decorator.getClass().getSimpleName())) {
                decorators.add(decorator);
                continue;
            }
            log.debug("{} disabled", (Object)decorator.getClass().getSimpleName());
        }
        for (String splitByTag : Config.get().getSplitByTags()) {
            decorators.add(new ServiceNameDecorator(splitByTag, true));
        }
        return decorators;
    }
}

