/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.scopemanager;

import datadog.opentracing.DDSpan;
import datadog.opentracing.scopemanager.ContinuableScope;
import datadog.opentracing.scopemanager.DDScope;
import datadog.opentracing.scopemanager.ScopeContext;
import datadog.opentracing.scopemanager.SimpleScope;
import datadog.trace.context.ScopeListener;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.noop.NoopScopeManager;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualScopeManager
implements ScopeManager {
    private static final Logger log = LoggerFactory.getLogger(ContextualScopeManager.class);
    static final ThreadLocal<DDScope> tlsScope = new ThreadLocal();
    final Deque<ScopeContext> scopeContexts = new ConcurrentLinkedDeque<ScopeContext>();
    final List<ScopeListener> scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
    private final int depthLimit;

    public ContextualScopeManager(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public Scope activate(Span span, boolean finishOnClose) {
        int currentDepth;
        Scope active = this.active();
        if (active instanceof DDScope && this.depthLimit <= (currentDepth = ((DDScope)active).depth())) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        for (ScopeContext context : this.scopeContexts) {
            if (!context.inContext()) continue;
            return context.activate(span, finishOnClose);
        }
        if (span instanceof DDSpan) {
            return new ContinuableScope(this, (DDSpan)span, finishOnClose);
        }
        return new SimpleScope(this, span, finishOnClose);
    }

    public Scope activate(Span span) {
        return this.activate(span, false);
    }

    public Scope active() {
        for (ScopeContext csm : this.scopeContexts) {
            if (!csm.inContext()) continue;
            return csm.active();
        }
        return tlsScope.get();
    }

    public Span activeSpan() {
        for (ScopeContext csm : this.scopeContexts) {
            if (!csm.inContext()) continue;
            return csm.activeSpan();
        }
        DDScope active = tlsScope.get();
        return active == null ? null : active.span();
    }

    @Deprecated
    public void addScopeContext(ScopeContext context) {
        this.scopeContexts.addFirst(context);
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeListeners.add(listener);
    }
}

