/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import datadog.opentracing.DDSpan;
import datadog.trace.common.sampling.DeterministicSampler;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.RateSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateByServiceSampler
implements Sampler,
PrioritySampler,
DDAgentResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceSampler.class);
    public static final String SAMPLING_AGENT_RATE = "_dd.agent_psr";
    private static final String DEFAULT_KEY = "service:,env:";
    private static final double DEFAULT_RATE = 1.0;
    private volatile Map<String, RateSampler> serviceRates = Collections.unmodifiableMap(Collections.singletonMap("service:,env:", this.createRateSampler(1.0)));

    @Override
    public boolean sample(DDSpan span) {
        return true;
    }

    @Override
    public void setSamplingPriority(DDSpan span) {
        boolean priorityWasSet;
        String serviceName = span.getServiceName();
        String env = RateByServiceSampler.getSpanEnv(span);
        String key = "service:" + serviceName + ",env:" + env;
        Map<String, RateSampler> rates = this.serviceRates;
        RateSampler sampler = this.serviceRates.get(key);
        if (sampler == null) {
            sampler = rates.get(DEFAULT_KEY);
        }
        if (priorityWasSet = sampler.sample(span) ? span.context().setSamplingPriority(1) : span.context().setSamplingPriority(0)) {
            span.context().setMetric(SAMPLING_AGENT_RATE, sampler.getSampleRate());
        }
    }

    private static String getSpanEnv(DDSpan span) {
        return null == span.getTags().get("env") ? "" : String.valueOf(span.getTags().get("env"));
    }

    @Override
    public void onResponse(String endpoint, JsonNode responseJson) {
        JsonNode newServiceRates = responseJson.get("rate_by_service");
        if (null != newServiceRates) {
            log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, (Object)responseJson);
            HashMap<String, RateSampler> updatedServiceRates = new HashMap<String, RateSampler>();
            Iterator itr = newServiceRates.fieldNames();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                JsonNode value = newServiceRates.get(key);
                try {
                    if (value instanceof NumericNode) {
                        updatedServiceRates.put(key, this.createRateSampler(value.doubleValue()));
                        continue;
                    }
                    log.debug("Unable to parse new service rate {} -> {}", (Object)key, (Object)value);
                }
                catch (NumberFormatException nfe) {
                    log.debug("Unable to parse new service rate {} -> {}", (Object)key, (Object)value);
                }
            }
            if (!updatedServiceRates.containsKey(DEFAULT_KEY)) {
                updatedServiceRates.put(DEFAULT_KEY, this.createRateSampler(1.0));
            }
            this.serviceRates = Collections.unmodifiableMap(updatedServiceRates);
        }
    }

    private RateSampler createRateSampler(double sampleRate) {
        double sanitizedRate;
        if (sampleRate < 0.0) {
            log.error("SampleRate is negative or null, disabling the sampler");
            sanitizedRate = 1.0;
        } else {
            sanitizedRate = sampleRate > 1.0 ? 1.0 : sampleRate;
        }
        return new DeterministicSampler(sanitizedRate);
    }
}

