/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.common.serialization.JsonFormatWriter;
import datadog.trace.common.writer.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(LoggingWriter.class);

    @Override
    public void write(List<DDSpan> trace) {
        if (log.isInfoEnabled()) {
            try {
                log.info("write(trace): {}", (Object)this.toString(trace));
            }
            catch (Exception e) {
                log.error("error writing(trace): {}", trace);
            }
        }
    }

    private String toString(List<DDSpan> trace) {
        return JsonFormatWriter.TRACE_ADAPTER.toJson(trace);
    }

    @Override
    public void incrementTraceCount() {
        log.info("incrementTraceCount()");
    }

    @Override
    public void close() {
        log.info("close()");
    }

    @Override
    public void start() {
        log.info("start()");
    }

    public String toString() {
        return "LoggingWriter { }";
    }
}

