/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.api.Config;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.LoggingWriter;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.Monitor;
import java.io.Closeable;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Writer
extends Closeable {
    public void write(List<DDSpan> var1);

    public void start();

    @Override
    public void close();

    public void incrementTraceCount();

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Writer forConfig(Config config) {
            Writer writer;
            if (config != null) {
                String configuredType = config.getWriterType();
                if ("DDAgentWriter".equals(configuredType)) {
                    writer = Builder.createAgentWriter(config);
                } else if ("LoggingWriter".equals(configuredType)) {
                    writer = new LoggingWriter();
                } else {
                    log.warn("Writer type not configured correctly: Type {} not recognized. Defaulting to DDAgentWriter.", (Object)configuredType);
                    writer = Builder.createAgentWriter(config);
                }
            } else {
                log.warn("Writer type not configured correctly: No config provided! Defaulting to DDAgentWriter.");
                writer = DDAgentWriter.builder().build();
            }
            return writer;
        }

        public static Writer forConfig(Properties config) {
            return Builder.forConfig(Config.get((Properties)config));
        }

        private static Writer createAgentWriter(Config config) {
            return DDAgentWriter.builder().agentApi(Builder.createApi(config)).monitor(Builder.createMonitor(config)).build();
        }

        private static DDAgentApi createApi(Config config) {
            return new DDAgentApi(config.getAgentHost(), config.getAgentPort(), config.getAgentUnixDomainSocket());
        }

        private static Monitor createMonitor(Config config) {
            Integer port;
            if (!config.isHealthMetricsEnabled()) {
                return new Monitor.Noop();
            }
            String host = config.getHealthMetricsStatsdHost();
            if (host == null) {
                host = config.getJmxFetchStatsdHost();
            }
            if (host == null) {
                host = config.getAgentHost();
            }
            if ((port = config.getHealthMetricsStatsdPort()) == null) {
                port = config.getJmxFetchStatsdPort();
            }
            return new Monitor.StatsD(host, port);
        }

        private Builder() {
        }
    }
}

