/*
 * Decompiled with CFR 0.152.
 */
package datadog.common.exec;

import datadog.common.exec.DaemonThreadFactory;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonTaskExecutor
extends AbstractExecutorService {
    private static final Logger log = LoggerFactory.getLogger(CommonTaskExecutor.class);
    public static final CommonTaskExecutor INSTANCE = new CommonTaskExecutor();
    private static final long SHUTDOWN_WAIT_SECONDS = 5L;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.TASK_SCHEDULER);

    private CommonTaskExecutor() {
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownCallback(this.executorService));
        }
        catch (IllegalStateException ex) {
            log.debug("Error adding shutdown hook", (Throwable)ex);
        }
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private static final class ShutdownCallback
    extends Thread {
        private final ScheduledExecutorService executorService;

        private ShutdownCallback(ScheduledExecutorService executorService) {
            super("dd-exec-shutdown-hook");
            this.executorService = executorService;
        }

        @Override
        public void run() {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
    }
}

