/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.serialization;

import datadog.opentracing.DDSpan;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public abstract class FormatWriter<DEST> {
    public abstract void writeKey(String var1, DEST var2) throws IOException;

    public abstract void writeListHeader(int var1, DEST var2) throws IOException;

    public abstract void writeListFooter(DEST var1) throws IOException;

    public abstract void writeMapHeader(int var1, DEST var2) throws IOException;

    public abstract void writeMapFooter(DEST var1) throws IOException;

    public abstract void writeString(String var1, String var2, DEST var3) throws IOException;

    public abstract void writeShort(String var1, short var2, DEST var3) throws IOException;

    public abstract void writeByte(String var1, byte var2, DEST var3) throws IOException;

    public abstract void writeInt(String var1, int var2, DEST var3) throws IOException;

    public abstract void writeLong(String var1, long var2, DEST var4) throws IOException;

    public abstract void writeFloat(String var1, float var2, DEST var3) throws IOException;

    public abstract void writeDouble(String var1, double var2, DEST var4) throws IOException;

    public abstract void writeBigInteger(String var1, BigInteger var2, DEST var3) throws IOException;

    public void writeNumber(String key, Number value, DEST destination) throws IOException {
        if (value instanceof Double) {
            this.writeDouble(key, value.doubleValue(), destination);
        } else if (value instanceof Long) {
            this.writeLong(key, value.longValue(), destination);
        } else if (value instanceof Integer) {
            this.writeInt(key, value.intValue(), destination);
        } else if (value instanceof Float) {
            this.writeFloat(key, value.floatValue(), destination);
        } else if (value instanceof Byte) {
            this.writeByte(key, value.byteValue(), destination);
        } else if (value instanceof Short) {
            this.writeShort(key, value.shortValue(), destination);
        }
    }

    public void writeNumberMap(String key, Map<String, Number> value, DEST destination) throws IOException {
        this.writeKey(key, destination);
        this.writeMapHeader(value.size(), destination);
        for (Map.Entry<String, Number> entry : value.entrySet()) {
            this.writeNumber(entry.getKey(), entry.getValue(), destination);
        }
        this.writeMapFooter(destination);
    }

    public void writeStringMap(String key, Map<String, String> value, DEST destination) throws IOException {
        this.writeKey(key, destination);
        this.writeMapHeader(value.size(), destination);
        for (Map.Entry<String, String> entry : value.entrySet()) {
            this.writeString(entry.getKey(), entry.getValue(), destination);
        }
        this.writeMapFooter(destination);
    }

    public void writeTrace(List<DDSpan> trace, DEST destination) throws IOException {
        this.writeListHeader(trace.size(), destination);
        for (DDSpan span : trace) {
            this.writeDDSpan(span, destination);
        }
        this.writeListFooter(destination);
    }

    public void writeDDSpan(DDSpan span, DEST destination) throws IOException {
        this.writeMapHeader(12, destination);
        this.writeString("service", span.getServiceName(), destination);
        this.writeString("name", span.getOperationName(), destination);
        this.writeString("resource", span.getResourceName(), destination);
        this.writeBigInteger("trace_id", span.getTraceId(), destination);
        this.writeBigInteger("span_id", span.getSpanId(), destination);
        this.writeBigInteger("parent_id", span.getParentId(), destination);
        this.writeLong("start", span.getStartTime(), destination);
        this.writeLong("duration", span.getDurationNano(), destination);
        this.writeString("type", span.getType(), destination);
        this.writeInt("error", span.getError(), destination);
        this.writeNumberMap("metrics", span.getMetrics(), destination);
        this.writeStringMap("meta", span.getMeta(), destination);
        this.writeMapFooter(destination);
    }
}

