/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.processor.rule;

import datadog.opentracing.DDSpan;
import datadog.trace.common.processor.TraceProcessor;
import java.util.Collection;
import java.util.Map;

public class AnalyticsSampleRateRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[]{"AnalyticsSampleRateDecorator"};
    }

    @Override
    public void processSpan(DDSpan span, Map<String, Object> tags, Collection<DDSpan> trace) {
        Object sampleRateValue = tags.get("_dd1.sr.eausr");
        if (sampleRateValue instanceof Number) {
            span.context().setMetric("_dd1.sr.eausr", (Number)sampleRateValue);
        } else if (sampleRateValue instanceof String) {
            try {
                span.context().setMetric("_dd1.sr.eausr", Double.parseDouble((String)sampleRateValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tags.containsKey("_dd1.sr.eausr")) {
            span.setTag("_dd1.sr.eausr", (String)null);
        }
    }
}

