/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.processor.rule;

import datadog.opentracing.DDSpan;
import datadog.trace.common.processor.TraceProcessor;
import io.opentracing.tag.Tags;
import java.util.Collection;
import java.util.Map;

public class DBStatementRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[]{"DBStatementAsResourceName"};
    }

    @Override
    public void processSpan(DDSpan span, Map<String, Object> tags, Collection<DDSpan> trace) {
        Object dbStatementValue = tags.get(Tags.DB_STATEMENT.getKey());
        if (dbStatementValue instanceof String) {
            if (tags.containsKey(Tags.COMPONENT.getKey()) && "java-mongo".equals(tags.get(Tags.COMPONENT.getKey()))) {
                return;
            }
            String statement = (String)dbStatementValue;
            if (!statement.isEmpty()) {
                span.setResourceName(statement);
            }
        }
        if (tags.containsKey(Tags.DB_STATEMENT.getKey())) {
            span.setTag(Tags.DB_STATEMENT.getKey(), (String)null);
        }
    }
}

