/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.processor.rule;

import datadog.opentracing.DDSpan;
import datadog.trace.api.Config;
import datadog.trace.common.processor.TraceProcessor;
import io.opentracing.tag.Tags;
import java.util.Collection;
import java.util.Map;

public class HttpStatusErrorRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[0];
    }

    @Override
    public void processSpan(DDSpan span, Map<String, Object> tags, Collection<DDSpan> trace) {
        Object value = tags.get(Tags.HTTP_STATUS.getKey());
        if (value != null && !span.context().getErrorFlag()) {
            try {
                int status;
                int n = status = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                if (span.getType().equals("web")) {
                    if (Config.get().getHttpServerErrorStatuses().contains(status)) {
                        span.setError(true);
                    }
                } else if (span.getType().equals("http") && Config.get().getHttpClientErrorStatuses().contains(status)) {
                    span.setError(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

